package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.ClientCategory;
import com.imcode.imcms.addon.imagearchive.repository.ClientCategoryRepository;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class ClientCategoryServiceImpl implements ClientCategoryService {
    @Autowired
    private ClientCategoryRepository repository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean existsCategory(final String categoryName) {
        return repository.findByName(categoryName) != null;
    }

    public ClientCategory createCategory(final String categoryName) throws CategoryExistsException {
        if (repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }

        ClientCategory category = new ClientCategory(categoryName);

        return repository.save(category);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public ClientCategory getCategory(final Long categoryId) {
        return repository.findOne(categoryId);
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<ClientCategory> getCategories() {
        return repository.findAll();
    }

    public void deleteCategory(final Long categoryId) {
        repository.delete(categoryId);
    }

    public void updateCategory(final Long categoryId, final String categoryName) throws CategoryExistsException {
        ClientCategory existsCategory = repository.findOne(categoryId);

        if (existsCategory != null && repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            repository.save(existsCategory);
        }
    }

    public ClientCategory getCategory(String name) {
        return repository.findByName(name);
    }
}

