/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.tag.func.Functions;
import com.imcode.imcms.addon.imagearchive.util.ValidatorUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchImageValidator
implements Validator {
    private Collection<Category> availableCategories;

    public SearchImageValidator(Collection<Category> categories) {
        this.availableCategories = categories;
    }

    public boolean supports(Class clazz) {
        return SearchImageCommand.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        short sortBy;
        SearchImageCommand command = (SearchImageCommand)target;
        short show = command.getShow();
        if (show < 0 || show > 3) {
            command.setShow((short)0);
        }
        ArrayList<Integer> availableCategoryIds = new ArrayList<Integer>();
        for (Category category : this.availableCategories) {
            if (null == category) continue;
            availableCategoryIds.add(category.getId().intValue());
        }
        availableCategoryIds.add(-2);
        if (command.getCategoryIds().contains(-1)) {
            command.setCategoryIds(availableCategoryIds);
        } else {
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            ArrayList<Integer> unavailableCategoryIds = new ArrayList<Integer>();
            Iterator iterator = command.getCategoryIds().iterator();
            while (iterator.hasNext()) {
                int categoryId = (Integer)iterator.next();
                if (availableCategoryIds.contains(categoryId)) {
                    categoryIds.add(categoryId);
                    continue;
                }
                unavailableCategoryIds.add(categoryId);
            }
            if (unavailableCategoryIds.size() > 0) {
                errors.rejectValue("categoryIds", "searchImage.categoryPermissionError", (Object[])new String[]{Functions.join(unavailableCategoryIds, (String)", ")}, null);
            }
            command.setCategoryIds(categoryIds);
        }
        ValidatorUtils.rejectValueIfLonger((String)"freetext", (int)120, (String)"fieldLengthError", (Errors)errors);
        command.setFreetext(StringUtils.trimToNull((String)command.getFreetext()));
        this.setDates(command, errors);
        int resultsPerPage = command.getResultsPerPage();
        if (resultsPerPage < 10 || resultsPerPage > 100) {
            command.setResultsPerPage(10);
        }
        if ((sortBy = command.getSortBy()) < 0 || sortBy > 2) {
            command.setSortBy((short)0);
        }
        String artist = StringUtils.trimToNull((String)command.getArtist());
        command.setArtist(artist);
    }

    private Date parseDate(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String utilDate = StringUtils.trimToNull((String)date);
        if (utilDate != null) {
            return df.parse(utilDate);
        }
        return null;
    }

    private void setDates(SearchImageCommand command, Errors errors) {
        try {
            command.setLicenseDate(this.parseDate(command.getLicenseDt()));
        }
        catch (ParseException ex) {
            errors.rejectValue("licenseDt", "invalidStartDateError");
        }
        try {
            command.setLicenseEndDate(this.parseDate(command.getLicenseEndDt()));
        }
        catch (ParseException ex) {
            errors.rejectValue("licenseEndDt", "invalidEndDateError");
        }
        try {
            command.setActiveDate(this.parseDate(command.getActiveDt()));
        }
        catch (ParseException ex) {
            errors.rejectValue("activeDt", "invalidStartDateError");
        }
        try {
            command.setActiveEndDate(this.parseDate(command.getActiveEndDt()));
        }
        catch (ParseException ex) {
            errors.rejectValue("activeEndDt", "invalidEndDateError");
        }
    }
}

