/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.command.ExportImageCommand;
import com.imcode.imcms.addon.imagearchive.command.ImageCardChangeActionCommand;
import com.imcode.imcms.addon.imagearchive.editors.EnumEditor;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifData;
import com.imcode.imcms.addon.imagearchive.util.exif.ExifUtils;
import com.imcode.imcms.addon.imagearchive.util.exif.Flash;
import com.imcode.imcms.addon.imagearchive.util.image.Filter;
import com.imcode.imcms.addon.imagearchive.util.image.Format;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import com.imcode.imcms.addon.imagearchive.util.image.Resize;
import com.imcode.imcms.addon.imagearchive.validator.ChangeImageDataValidator;
import com.imcode.imcms.addon.imagearchive.validator.ExportImageValidator;
import com.imcode.imcms.addon.imagearchive.validator.ImageUploadValidator;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class ImageCardController {
    private static final Log log = LogFactory.getLog(ImageCardController.class);
    private static final Pattern IMAGE_ID_PATTERN = Pattern.compile("/archive/image/([^/]+)/?");
    private static final String IMAGE_KEY = Utils.makeKey(ImageCardController.class, (String)"image");
    @Autowired
    private Facade facade;
    @Autowired
    private Config config;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.registerCustomEditor(ExportImageCommand.SizeUnit.class, (PropertyEditor)new EnumEditor());
    }

    @RequestMapping(value={"/image/*", "/image/*/"})
    public ModelAndView indexHandler(@ModelAttribute(value="exportImage") ExportImageCommand command, BindingResult result, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Image image;
        User user = SessionUtils.getUser(request, session, this.facade);
        Long imageId = ImageCardController.getImageId(request);
        if (imageId == null || (image = this.facade.getImageService().findById(imageId)) == null || !ClientUtils.canUseOrChangeImage(image, user, this.facade)) {
            return new ModelAndView("redirect:/archive/");
        }
        if (command.getExport() != null && !image.isArchived() && ClientUtils.canUseOrChangeImage(image, user, this.facade)) {
            ExportImageValidator validator = new ExportImageValidator();
            ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
            Format imageFormat = Format.findFormat((short)command.getFileFormat());
            if (imageFormat != null && imageFormat.isWritable() && !result.hasErrors() && this.processExport(imageId, image, imageFormat, command, response)) {
                return null;
            }
        } else {
            Format format = Format.findFormat((short)image.getFormat());
            if (format.isWritable()) {
                command.setFileFormat(Short.valueOf(format.getOrdinal()));
            }
            command.setWidth(Integer.valueOf(image.getWidth()));
            command.setHeight(Integer.valueOf(image.getHeight()));
        }
        ModelAndView mav = new ModelAndView("image_card/image_card");
        mav.addObject("image", (Object)image);
        mav.addObject("categories", (Object)ImageCardController.getCategories(image));
        mav.addObject("keywords", (Object)ImageCardController.getKeywords(image));
        mav.addObject("canUseInImcms", (Object)(SessionUtils.getImcmsReturnToUrl(request.getSession()) != null && ClientUtils.canUseOrChangeImage(image, user, this.facade) ? 1 : 0));
        mav.addObject("format", (Object)Format.findFormat((short)image.getFormat()));
        mav.addObject("canExport", (Object)ClientUtils.canUseOrChangeImage(image, user, this.facade));
        return mav;
    }

    @RequestMapping(value={"/image/*/exif"})
    public ModelAndView exifHandler(@ModelAttribute(value="exportImage") ExportImageCommand command, HttpServletRequest request, HttpSession session) {
        Image image;
        User user = SessionUtils.getUser(request, session, this.facade);
        Long imageId = ImageCardController.getImageId(request);
        if (imageId == null || (image = this.facade.getImageService().findById(imageId)) == null || ClientUtils.canUseOrChangeImage(image, user, this.facade)) {
            return new ModelAndView("redirect:/archive");
        }
        Format format = Format.findFormat((short)image.getFormat());
        if (format.isWritable()) {
            command.setFileFormat(Short.valueOf(format.getOrdinal()));
        }
        command.setWidth(Integer.valueOf(image.getWidth()));
        command.setHeight(Integer.valueOf(image.getHeight()));
        Exif originalExif = this.facade.getImageService().findExifByPK(image.getId());
        image.setExif(originalExif);
        ModelAndView mav = new ModelAndView("image_card/image_card");
        mav.addObject("action", (Object)"exif");
        mav.addObject("image", (Object)image);
        mav.addObject("canExport", (Object)ClientUtils.canUseOrChangeImage(image, user, this.facade));
        mav.addObject("canUseInImcms", (Object)(SessionUtils.getImcmsReturnToUrl(request.getSession()) != null && ClientUtils.canUseOrChangeImage(image, user, this.facade) ? 1 : 0));
        return mav;
    }

    @RequestMapping(value={"/image/*/erase"})
    public ModelAndView eraseHandler(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            ClientUtils.redirectToLogin(response, this.facade);
            return null;
        }
        Long imageId = ImageCardController.getImageId(request);
        Image image = this.facade.getImageService().findById(imageId);
        image.setCanChange(ClientUtils.canChangeImage(image, user, this.facade));
        if (imageId == null || image == null) {
            return new ModelAndView("redirect:/archive/");
        }
        if (image.isArchived() || !image.isCanChange()) {
            return new ModelAndView("redirect:/archive/image/" + imageId);
        }
        this.facade.getImageService().archiveImage(imageId);
        return new ModelAndView("redirect:/archive/");
    }

    @RequestMapping(value={"/image/*/change"})
    public ModelAndView changeHandler(@ModelAttribute(value="changeData") ChangeImageDataCommand changeData, BindingResult result, @ModelAttribute ImageCardChangeActionCommand action, HttpServletRequest request, @RequestParam(required=false) Boolean redirectToImageCard, HttpSession session) {
        Image image;
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            return new ModelAndView("redirect:/archive/");
        }
        Long imageId = ImageCardController.getImageId(request);
        if (imageId == null) {
            return new ModelAndView("redirect:/archive/");
        }
        HashSet<Category> categories = new HashSet<Category>();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        ModelAndView mav = new ModelAndView("image_card/image_card");
        mav.addObject("action", (Object)"change");
        if (!action.isSet()) {
            image = this.facade.getImageService().findById(imageId);
            image.setCanChange(ClientUtils.canChangeImage(image, user, this.facade));
            if (image == null) {
                return new ModelAndView("redirect:/archive/");
            }
            if (image.isArchived() || !image.isCanChange()) {
                return new ModelAndView("redirect:/archive/image/" + imageId);
            }
            session.setAttribute(IMAGE_KEY, (Object)image);
            changeData.fromImage(image);
            mav.addObject("image", (Object)image);
            mav.addObject("format", (Object)Format.findFormat((short)image.getFormat()));
            this.facade.getFileService().createTemporaryCopyOfCurrentImage(image.getId().longValue());
            List imageCategory = this.facade.getImageService().findImageCategories(image.getId());
            mav.addObject("categories", ImageCardController.getAvailableCategories(categories, imageCategory));
            mav.addObject("imageCategories", (Object)imageCategory);
            List keywords = this.facade.getImageService().findAvailableKeywords(image.getId());
            List imageKeywords = this.facade.getImageService().findImageKeywords(image.getId());
            mav.addObject("keywords", (Object)keywords);
            mav.addObject("imageKeywords", (Object)imageKeywords);
        } else {
            image = (Image)session.getAttribute(IMAGE_KEY);
            image.setCanChange(ClientUtils.canChangeImage(image, user, this.facade));
            if (image == null) {
                return new ModelAndView("redirect:/archive/");
            }
            if (!image.isCanChange()) {
                return new ModelAndView("redirect:/archive/image/" + imageId);
            }
            mav.addObject("image", (Object)image);
            mav.addObject("format", (Object)Format.findFormat((short)image.getFormat()));
            if (action.isCancel()) {
                session.removeAttribute(IMAGE_KEY);
                this.facade.getFileService().deleteTemporaryImage(imageId.longValue());
                return new ModelAndView("redirect:/archive/image/" + image.getId());
            }
            List keywords = changeData.getKeywordNames();
            List imageKeywords = changeData.getImageKeywordNames();
            List imageCategory = this.facade.getImageService().findImageCategories(image.getId());
            mav.addObject("keywords", (Object)keywords);
            mav.addObject("imageKeywords", (Object)imageKeywords);
            mav.addObject("categories", ImageCardController.getAvailableCategories(categories, imageCategory));
            mav.addObject("imageCategories", (Object)imageCategory);
            if (action.isUpload()) {
                ImageUploadValidator validator = new ImageUploadValidator(this.facade);
                ValidationUtils.invokeValidator((Validator)validator, (Object)changeData.getFile(), (Errors)result);
                String copyright = "";
                String description = "";
                String artist = "";
                String manufacturer = null;
                String model = null;
                String compression = null;
                Double exposure = null;
                String exposureProgram = null;
                Float fStop = null;
                Date dateOriginal = null;
                Date dateDigitized = null;
                Flash flash = null;
                Float focalLength = null;
                String colorSpace = null;
                Integer xResolution = null;
                Integer yResolution = null;
                Integer resolutionUnit = null;
                Integer pixelXDimension = null;
                Integer pixelYDimension = null;
                Integer ISO = null;
                File tempFile = validator.getTempFile();
                ExifData data = ExifUtils.getExifData((File)tempFile);
                if (data != null) {
                    copyright = StringUtils.substring((String)data.getCopyright(), (int)0, (int)255);
                    description = StringUtils.substring((String)data.getDescription(), (int)0, (int)255);
                    artist = StringUtils.substring((String)data.getArtist(), (int)0, (int)255);
                    xResolution = data.getxResolution();
                    yResolution = data.getyResolution();
                    manufacturer = data.getManufacturer();
                    model = data.getModel();
                    compression = data.getCompression();
                    exposure = data.getExposure();
                    exposureProgram = data.getExposureProgram();
                    fStop = data.getfStop();
                    flash = data.getFlash();
                    focalLength = data.getFocalLength();
                    colorSpace = data.getColorSpace();
                    resolutionUnit = data.getResolutionUnit();
                    pixelXDimension = data.getPixelXDimension();
                    pixelYDimension = data.getPixelYDimension();
                    ISO = data.getISO();
                    dateOriginal = data.getDateOriginal();
                    dateDigitized = data.getDateDigitized();
                }
                int fileSize = (int)tempFile.length();
                if (!this.facade.getFileService().storeImage(tempFile, imageId.longValue(), true)) {
                    return mav;
                }
                changeData.setChangedFile(true);
                image.setFileSize(fileSize);
                Exif originalExif = new Exif(xResolution, yResolution, description, artist, copyright, manufacturer, model, compression, exposure, exposureProgram, fStop, flash, focalLength, colorSpace, resolutionUnit, pixelXDimension, pixelYDimension, dateOriginal, dateDigitized, ISO);
                image.setExif(originalExif);
                image.setName(StringUtils.substring((String)validator.getImageName(), (int)0, (int)255));
                String uploadedBy = "";
                image.setUploadedBy(uploadedBy);
                ImageInfo imageInfo = validator.getImageInfo();
                image.setFormat(imageInfo.getFormat().getOrdinal());
                image.setWidth(imageInfo.getWidth());
                image.setHeight(imageInfo.getHeight());
                changeData.fromImage(image);
                return mav;
            }
            ChangeImageDataValidator validator = new ChangeImageDataValidator(this.facade);
            ValidationUtils.invokeValidator((Validator)validator, (Object)changeData, (Errors)result);
            if (action.getRotateLeft() != null) {
                this.facade.getFileService().rotateImage(image.getId().longValue(), -90, true);
                changeData.setRotation(changeData.getRotation() - 90);
                if (changeData.getRotation() <= -360) {
                    changeData.setRotation(0);
                }
            } else if (action.getRotateRight() != null) {
                this.facade.getFileService().rotateImage(image.getId().longValue(), 90, true);
                changeData.setRotation(changeData.getRotation() + 90);
                if (changeData.getRotation() >= 360) {
                    changeData.setRotation(0);
                }
            } else if (!result.hasErrors()) {
                changeData.toImage(image);
                if (changeData.isChangedFile()) {
                    this.facade.getImageService().updateFullData(image, changeData.getCategoryIds(), imageKeywords);
                    changeData.setChangedFile(false);
                } else {
                    this.facade.getImageService().updateData(image, changeData.getCategoryIds(), imageKeywords);
                }
                imageCategory = this.facade.getImageService().findImageCategories(image.getId());
                mav.getModel().remove("categories");
                mav.getModel().remove("imageCategories");
                mav.addObject("categories", ImageCardController.getAvailableCategories(categories, imageCategory));
                mav.addObject("imageCategories", (Object)imageCategory);
                this.facade.getFileService().copyTemporaryImageToCurrent(imageId.longValue());
                if (action.isUse()) {
                    this.facade.getFileService().deleteTemporaryImage(image.getId().longValue());
                    session.removeAttribute(IMAGE_KEY);
                    return new ModelAndView("redirect:/archive/use?id=" + image.getId());
                }
                if (action.isImageCard()) {
                    this.facade.getFileService().deleteTemporaryImage(image.getId().longValue());
                    session.removeAttribute(IMAGE_KEY);
                    return new ModelAndView("redirect:/archive/image/" + image.getId());
                }
                if (redirectToImageCard != null && redirectToImageCard.booleanValue()) {
                    this.facade.getFileService().deleteTemporaryImage(image.getId().longValue());
                    session.removeAttribute(IMAGE_KEY);
                    return new ModelAndView("redirect:/archive/image/" + image.getId());
                }
            }
        }
        return mav;
    }

    private static Long getImageId(HttpServletRequest request) {
        String uri = request.getRequestURI();
        Matcher matcher = IMAGE_ID_PATTERN.matcher(uri);
        if (matcher.find()) {
            try {
                return Long.parseLong(matcher.group(1), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @RequestMapping(value={"/image/*/unarchive"})
    public ModelAndView unarchiveHandler(HttpServletRequest request, HttpSession session) {
        Long imageId = ImageCardController.getImageId(request);
        if (imageId == null || this.facade.getImageService().findById(imageId) == null) {
            return new ModelAndView("redirect:/archive");
        }
        this.facade.getImageService().unarchiveImage(imageId);
        return new ModelAndView("redirect:/archive/image/" + imageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processExport(Long imageId, Image image, Format imageFormat, ExportImageCommand command, HttpServletResponse response) {
        block16: {
            File tempFile = null;
            try {
                tempFile = this.facade.getFileService().createTemporaryFile("export");
                File originalFile = this.facade.getFileService().getImageOriginalFile(imageId.longValue(), false);
                ImageOp op = new ImageOp(this.config).input(originalFile);
                Integer width = command.getWidth();
                Integer height = command.getHeight();
                if (width != null || height != null) {
                    Resize resize;
                    Resize resize2 = resize = width != null && height != null && !command.isKeepAspectRatio() ? Resize.FORCE : Resize.DEFAULT;
                    if (ExportImageCommand.SizeUnit.PECENT.equals((Object)command.getSizeUnit())) {
                        resize = Resize.PERCENT;
                    }
                    op.filter(Filter.LANCZOS);
                    op.resize(width, height, resize);
                }
                op.quality(command.getQuality().intValue());
                op.outputFormat(imageFormat);
                if (!op.processToFile(tempFile)) {
                    boolean resize = false;
                    return resize;
                }
                if (imageFormat == Format.JPEG) {
                    File exifTempFile = this.facade.getFileService().createTemporaryFile("export_exif");
                    ExifData data = new ExifData();
                    Exif changedExif = image.getExif();
                    data.setArtist(changedExif.getArtist());
                    data.setCopyright(changedExif.getCopyright());
                    data.setDescription(changedExif.getDescription());
                    boolean res = ExifUtils.writeExifData((File)tempFile, (ExifData)data, (File)exifTempFile);
                    if (res) {
                        tempFile.delete();
                        tempFile = exifTempFile;
                    } else {
                        exifTempFile.delete();
                    }
                }
                response.setContentType(imageFormat.getMimeType());
                response.setContentLength((int)tempFile.length());
                String contentDisposition = image.getName() != null && !image.getName().equals("") ? String.format("attachment; filename=" + image.getName() + ".%s", imageFormat.getExtension()) : String.format("attachment; filename=export_img_%d.%s", imageId, imageFormat.getExtension());
                response.setHeader("Content-Disposition", contentDisposition);
                BufferedOutputStream output = null;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(tempFile);
                    output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    ((OutputStream)output).flush();
                    IOUtils.closeQuietly((OutputStream)output);
                }
                catch (Exception ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block16;
                }
                finally {
                    IOUtils.closeQuietly(output);
                    IOUtils.closeQuietly((InputStream)input);
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        return true;
    }

    private static Collection<Category> getAvailableCategories(Collection<Category> all, Collection<Category> exist) {
        ArrayList<Category> result = new ArrayList<Category>(all);
        result.removeAll(exist);
        return result;
    }

    private static String getCategories(Image image) {
        List categories = image.getCategories();
        StringBuilder categoryBuilder = new StringBuilder();
        int len = categories.size();
        for (int i = 0; i < len; ++i) {
            Category category = (Category)categories.get(i);
            categoryBuilder.append(category.getName());
            if (i >= len - 1) continue;
            categoryBuilder.append(", ");
        }
        return categoryBuilder.toString();
    }

    private static String getKeywords(Image image) {
        List keywords = image.getKeywords();
        StringBuilder keywordBuilder = new StringBuilder();
        int len = keywords.size();
        for (int i = 0; i < len; ++i) {
            keywordBuilder.append(((Keyword)keywords.get(i)).getName());
            if (i >= len - 1) continue;
            keywordBuilder.append(", ");
        }
        return keywordBuilder.toString();
    }
}

