/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.command.CreateCategoryCommand;
import com.imcode.imcms.addon.imagearchive.command.CreateKeywordCommand;
import com.imcode.imcms.addon.imagearchive.command.EditCategoryCommand;
import com.imcode.imcms.addon.imagearchive.command.EditKeywordCommand;
import com.imcode.imcms.addon.imagearchive.command.PreferencesActionCommand;
import com.imcode.imcms.addon.imagearchive.command.SaveLibraryRolesCommand;
import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.validator.CreateCategoryValidator;
import com.imcode.imcms.addon.imagearchive.validator.CreateKeywordValidator;
import com.imcode.imcms.addon.imagearchive.validator.EditCategoryValidator;
import com.imcode.imcms.addon.imagearchive.validator.EditKeywordValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class PreferencesController {
    private static final Log log = LogFactory.getLog(PreferencesController.class);
    private static final String ROLE_KEY = Utils.makeKey(PreferencesController.class, (String)"role");
    private static final String LIBRARY_KEY = Utils.makeKey(PreferencesController.class, (String)"library");
    @Autowired
    private Facade facade;

    @RequestMapping(value={"/preferences"})
    public String indexHandler(@ModelAttribute PreferencesActionCommand actionCommand, @ModelAttribute(value="createCategory") CreateCategoryCommand createCategoryCommand, BindingResult createCategoryResult, @ModelAttribute(value="editCategory") EditCategoryCommand editCategoryCommand, BindingResult editCategoryResult, @ModelAttribute(value="createKeyword") CreateKeywordCommand createKeywordCommand, BindingResult createKeywordResult, @ModelAttribute(value="editKeyword") EditKeywordCommand editKeywordCommand, BindingResult editKeywordResult, @ModelAttribute(value="saveLibraryRoles") SaveLibraryRolesCommand librariesCommand, BindingResult librariesResult, @ModelAttribute(value="saveCategories") SaveRoleCategoriesCommand roleCategoriesCommand, HttpServletRequest request, HttpServletResponse response, HttpSession session, Map<String, Object> model) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            ClientUtils.redirectToLogin(response, this.facade);
            return null;
        }
        if (!ClientUtils.canAccessPreferences(user, this.facade)) {
            return "redirect:/archive";
        }
        this.facade.getLibraryService().syncLibraryFolders();
        List roles = this.facade.getRoleService().getAllRoles();
        Role role = PreferencesController.getRole(session, roles);
        Role previousRole = (Role)session.getAttribute("previousRole");
        if (previousRole != null && !role.equals((Object)previousRole)) {
            model.put("editingRoles", true);
        }
        session.setAttribute("previousRole", (Object)role);
        model.put("currentRole", role);
        List libraries = this.facade.getLibraryService().findLibraries();
        final List firstLevelLibraries = this.facade.getFileService().listFirstLevelLibraryFolders();
        CollectionUtils.filter((Collection)libraries, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Library lib = (Library)o;
                return firstLevelLibraries.contains(new File(lib.getFilepath(), lib.getFolderNm()));
            }
        });
        Library library = PreferencesController.getLibrary(session, libraries);
        session.setAttribute("previousLibrary", (Object)library);
        model.put("currentLibrary", library);
        if (actionCommand.isCreateCategory()) {
            this.processCreateCategory(createCategoryCommand, createCategoryResult);
            model.put("editingCategories", true);
        } else if (actionCommand.isEditCategory()) {
            this.processEditCategory(editCategoryCommand);
            model.put("editingCategories", true);
        } else if (actionCommand.isSaveCategory()) {
            this.processSaveCategory(editCategoryCommand, editCategoryResult);
            model.put("editingCategories", true);
        } else if (actionCommand.isRemoveCategory()) {
            this.processRemoveCategory(editCategoryCommand);
            model.put("editingCategories", true);
        } else if (actionCommand.isCreateKeyword()) {
            this.processCreateKeyword(createKeywordCommand, createKeywordResult);
            model.put("editingKeywords", true);
        } else if (actionCommand.isSaveKeyword()) {
            this.processSaveKeyword(editKeywordCommand, editKeywordResult);
            model.put("editingKeywords", true);
        } else if (actionCommand.isRemoveKeyword()) {
            this.processRemoveKeyword(editKeywordCommand);
            model.put("editingKeywords", true);
        } else if (actionCommand.isSaveLibraryRoles() && library != null && librariesCommand.getLibraryRoles() != null) {
            this.processSaveLibraryRoles(librariesCommand, librariesResult, model);
            model.put("editingLibraries", true);
        } else if (actionCommand.isSaveRoleCategories()) {
            this.processSaveRoleCategories(roleCategoriesCommand, model);
            model.put("editingRoles", true);
        }
        if (!actionCommand.isSaveLibraryRoles() && library != null) {
            librariesCommand.setLibraryNm(library.getLibraryNm());
        }
        List libraryRoles = Collections.emptyList();
        if (library != null) {
            libraryRoles = this.facade.getLibraryService().findLibraryRoles(library.getId());
        }
        model.put("availableLibraryRoles", null);
        model.put("libraryRoles", libraryRoles);
        List categoryRoles = this.facade.getRoleService().getCategoryRolesByRole(role);
        model.put("categoryRoles", categoryRoles);
        model.put("categoryTypes", null);
        model.put("categories", this.facade.getCategoryService().getCategories());
        model.put("keywords", this.facade.getKeywordService().getKeywords());
        model.put("roles", roles);
        List categories = this.facade.getCategoryService().getCategories();
        model.put("libraries", libraries);
        model.put("freeCategories", categories);
        model.put("roleCategories", categories);
        model.put("allCategories", categories);
        return "preferences";
    }

    private void processCreateCategory(CreateCategoryCommand command, BindingResult result) {
        CreateCategoryValidator validator = new CreateCategoryValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            String categoryName = command.getCreateCategoryName();
            int categoryTypeId = command.getCreateCategoryType();
            try {
                this.facade.getCategoryService().createCategory(categoryName);
                command.setCreateCategoryName("");
                command.setCreateCategoryType(0);
            }
            catch (CategoryExistsException ex) {
                result.rejectValue("createCategoryName", "preferences.categoryExistsError");
            }
        }
    }

    private void processEditCategory(EditCategoryCommand command) {
        Category category = this.facade.getCategoryService().getCategory(Long.valueOf(command.getEditCategoryId()));
        if (category != null) {
            command.setShowEditCategory(true);
            command.setEditCategoryName(category.getName());
        }
    }

    private void processSaveCategory(EditCategoryCommand command, BindingResult result) {
        EditCategoryValidator validator = new EditCategoryValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            int categoryId = command.getEditCategoryId();
            String newName = command.getEditCategoryName();
            try {
                this.facade.getCategoryService().updateCategory(Long.valueOf(categoryId), newName);
            }
            catch (CategoryExistsException ex) {
                result.rejectValue("editCategoryName", "preferences.categoryExistsError");
            }
        }
    }

    private void processRemoveCategory(EditCategoryCommand command) {
        this.facade.getCategoryService().deleteCategory(Long.valueOf(command.getEditCategoryId()));
        command.setEditCategoryName("");
        command.setShowEditCategory(false);
    }

    private void processCreateKeyword(CreateKeywordCommand command, BindingResult result) {
        CreateKeywordValidator validator = new CreateKeywordValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            String keywordName = command.getCreateKeywordName();
            try {
                this.facade.getKeywordService().createKeyword(keywordName);
                command.setCreateKeywordName("");
            }
            catch (KeywordExistsException ex) {
                result.rejectValue("createKeywordName", "preferences.keywordExistsError");
            }
        }
    }

    private void processSaveKeyword(EditKeywordCommand command, BindingResult result) {
        EditKeywordValidator validator = new EditKeywordValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            long keywordId = command.getEditKeywordId();
            String KeywordName = command.getEditKeywordName();
            try {
                this.facade.getKeywordService().updateKeyword(Long.valueOf(keywordId), KeywordName);
            }
            catch (KeywordExistsException ex) {
                result.rejectValue("editKeywordName", "preferences.keywordExistsError");
            }
        }
    }

    private void processRemoveKeyword(EditKeywordCommand command) {
        this.facade.getKeywordService().deleteKeyword(Long.valueOf(command.getEditKeywordId()));
        command.setEditKeywordName("");
    }

    private void processSaveLibraryRoles(SaveLibraryRolesCommand command, BindingResult result, Map<String, Object> model) {
    }

    private void processSaveRoleCategories(SaveRoleCategoriesCommand command, Map<String, Object> model) {
        try {
            Role role = (Role)model.get("currentRole");
            this.facade.getRoleService().assignCategoryRoles(role, command.getAssignedCategoryIds());
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @RequestMapping(value={"/preferences/role"})
    public String changeCurrentRoleHandler(@RequestParam(required=false) Integer id, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Role role;
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            ClientUtils.redirectToLogin(response, this.facade);
            return null;
        }
        if (!ClientUtils.canAccessPreferences(user, this.facade)) {
            return "redirect:/archive";
        }
        if (id != null && (role = this.facade.getRoleService().getRoleById(id.intValue())) != null) {
            session.setAttribute(ROLE_KEY, (Object)role);
        }
        return "redirect:/archive/preferences";
    }

    @RequestMapping(value={"/preferences/library"})
    public String changeCurrentLibraryHander(@RequestParam(required=false) Long id, HttpServletResponse response, HttpSession session) {
        Library library;
        if (id != null && (library = this.facade.getLibraryService().findLibraryById(id)) != null) {
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return "redirect:/archive/preferences";
    }

    private static Role getRole(HttpSession session, List<Role> roles) {
        Role role = (Role)session.getAttribute(ROLE_KEY);
        if (role == null && roles != null) {
            role = roles.get(0);
            session.setAttribute(ROLE_KEY, (Object)role);
        }
        return role;
    }

    private static Library getLibrary(HttpSession session, List<Library> libraries) {
        Library library = (Library)session.getAttribute(LIBRARY_KEY);
        if (library != null && libraries != null) {
            boolean exists = false;
            for (Library lib : libraries) {
                if (lib.getId() != library.getId()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                library = null;
                session.removeAttribute(LIBRARY_KEY);
            }
        }
        if (library == null && libraries != null && !libraries.isEmpty()) {
            library = libraries.get(0);
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return library;
    }
}

