/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class ThumbnailController {
    private static final Log log = LogFactory.getLog(ThumbnailController.class);
    @Autowired
    private Facade facade;
    @Autowired
    private Config config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/thumb"})
    public void thumbHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) String size, @RequestParam(required=false) Boolean tmp, HttpServletResponse response, HttpServletRequest request, HttpSession session) throws IOException {
        size = StringUtils.trimToNull((String)size);
        ThumbSize thumbSize = null;
        if (id == null || size == null || (thumbSize = ThumbSize.findByName((String)size)) == null) {
            Utils.sendErrorCode(response, 404);
            return;
        }
        tmp = tmp != null && tmp != false;
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bytes = this.facade.getFileService().getThumbnail(id.longValue(), thumbSize, tmp.booleanValue());
            if (bytes == null || bytes.length == 0) {
                Utils.sendErrorCode(response, 404);
                return;
            }
            long length = bytes.length;
            inputStream = new ByteArrayInputStream(bytes);
            response.setContentType("image/jpeg");
            response.setContentLength((int)length);
            response.setHeader("Content-Disposition", String.format("inline; file=thumb_small_%d.jpg", id));
            BufferedOutputStream output = null;
            try {
                output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                ((OutputStream)output).flush();
            }
            catch (IOException ex) {
                IOUtils.closeQuietly(output);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    @RequestMapping(value={"/preview"})
    public String previewHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) Boolean tmp, HttpServletResponse response, Map<String, Object> model) {
        if (id == null) {
            Utils.sendErrorCode(response, 404);
            return null;
        }
        tmp = tmp != null ? tmp : false;
        model.put("imageId", id);
        model.put("temporary", tmp);
        return "preview";
    }

    @RequestMapping(value={"/detailed_thumb"})
    public String detailedThumbnail(@RequestParam(required=true) Long id, HttpServletResponse response, HttpServletRequest request, HttpSession session, Map<String, Object> model) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (id == null) {
            Utils.sendErrorCode(response, 404);
            return null;
        }
        Image image = this.facade.getImageService().findById(id);
        model.put("image", image);
        model.put("imageSize", ThumbSize.MEDIUM.getName());
        return "detailed_thumb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/preview_img"})
    public void previewHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) Boolean tmp, HttpServletResponse response, HttpServletRequest request, HttpSession session) throws IOException {
        ByteArrayInputStream inputStream;
        block9: {
            byte[] bytes;
            block8: {
                if (id == null) {
                    Utils.sendErrorCode(response, 404);
                    return;
                }
                tmp = tmp != null && tmp != false;
                inputStream = null;
                try {
                    bytes = this.facade.getFileService().getThumbnail(id.longValue(), ThumbSize.FULL, tmp.booleanValue());
                    if (bytes != null && bytes.length != 0) break block8;
                    Utils.sendErrorCode(response, 404);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream);
                return;
            }
            long length = bytes.length;
            inputStream = new ByteArrayInputStream(bytes);
            response.setContentType("image/jpeg");
            response.setContentLength((int)length);
            response.setHeader("Content-Disposition", String.format("inline; file=preview_%d.jpg", id));
            BufferedOutputStream output = null;
            try {
                output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                ((OutputStream)output).flush();
            }
            catch (Exception ex) {
                IOUtils.closeQuietly(output);
                break block9;
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

