/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.command.ExternalFilesCommand;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class ExternalFilesValidator
implements Validator {
    public static final String[] IMAGE_EXTENSIONS = new String[]{"ai", "bmp", "eps", "gif", "jpeg", "jpg", "pct", "pdf", "pic", "pict", "png", "ps", "psd", "svg", "tif", "tiff", "xcf", "AI", "BMP", "EPC", "GIF", "JPEG", "JPG", "PCT", "PDF", "PIC", "PICT", "PNG", "PS", "PSD", "SVG", "TIF", "TIFF", "XCF"};
    public static final Set<String> IMAGE_EXTENSIONS_SET = new HashSet<String>(Arrays.asList(IMAGE_EXTENSIONS));
    public static final Pattern FILENAME_PATTERN = Pattern.compile("^.*?/?([^/\\:]+?)$");
    public static final String OSX_RESOURCE_FORK_PREFIX = "__MACOSX/";
    private Facade facade;
    private boolean zipFile;
    private File tempFile;
    private String fileName;

    public ExternalFilesValidator(Facade facade) {
        this.facade = facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(Object target, Errors errors) {
        ExternalFilesCommand command = (ExternalFilesCommand)target;
        File localTempFile = null;
        if (command.getUpload() == null) return;
        CommonsMultipartFile file = command.getFile();
        if (file == null || file.getBytes() == null || file.getBytes().length == 0) {
            errors.rejectValue("file", "externalFiles.fileError");
            return;
        }
        try {
            this.fileName = file.getOriginalFilename();
            this.tempFile = this.facade.getImageService().uploadFile(file.getBytes());
            localTempFile = File.createTempFile("" + Math.random() * 1000.0, ".tmp");
            file.transferTo(localTempFile);
            ZipFile zip = null;
            try {
                zip = new ZipFile(localTempFile, 1);
                this.zipFile = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (zip != null) {
                    zip.close();
                }
            }
            long maxZipUploadSize = this.facade.getConfig().getMaxZipUploadSize();
            long maxImageUploadSize = this.facade.getConfig().getMaxImageUploadSize();
            long fileLength = localTempFile.length();
            double size = 0.0;
            boolean sizeError = false;
            if (this.zipFile && fileLength > maxZipUploadSize) {
                sizeError = true;
                size = maxZipUploadSize;
            } else if (!this.zipFile && fileLength > maxImageUploadSize) {
                sizeError = true;
                size = maxImageUploadSize;
            }
            if (sizeError) {
                errors.rejectValue("file", "externalFiles.fileSizeError", new Object[]{size /= 1048576.0}, "???");
                FileUtils.deleteQuietly((File)localTempFile);
                return;
            }
            if (!this.zipFile) {
                ImageInfo info = ImageOp.getImageInfo((Config)this.facade.getConfig(), (File)localTempFile);
                if (info == null) {
                    errors.rejectValue("file", "externalFiles.fileError");
                    FileUtils.deleteQuietly((File)localTempFile);
                    return;
                }
                Matcher matcher = FILENAME_PATTERN.matcher(this.fileName);
                if (!matcher.matches() || StringUtils.isEmpty((CharSequence)(this.fileName = StringUtils.trimToEmpty((String)matcher.group(1))))) {
                    errors.rejectValue("file", "externalFiles.fileError");
                    FileUtils.deleteQuietly((File)localTempFile);
                    return;
                }
                String extension = StringUtils.substringAfterLast((String)this.fileName, (String)".").toLowerCase();
                if (!IMAGE_EXTENSIONS_SET.contains(extension)) {
                    errors.rejectValue("file", "externalFiles.fileError");
                }
            }
            FileUtils.deleteQuietly((File)localTempFile);
            return;
        }
        catch (Exception ex) {
            errors.rejectValue("file", "externalFiles.fileError");
            return;
        }
        finally {
            FileUtils.deleteQuietly(localTempFile);
        }
    }

    public boolean supports(Class clazz) {
        return ExternalFilesCommand.class.isAssignableFrom(clazz);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public boolean isZipFile() {
        return this.zipFile;
    }

    public void setZipFile(boolean zipFile) {
        this.zipFile = zipFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

