/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.ValidatorUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ChangeImageDataValidator
implements Validator {
    private Facade facade;

    public ChangeImageDataValidator(Facade facade) {
        this.facade = facade;
    }

    public boolean supports(Class clazz) {
        return ChangeImageDataCommand.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        String licenseEndDt;
        ChangeImageDataCommand command = (ChangeImageDataCommand)target;
        ValidatorUtils.rejectValueIfLonger((String)"imageNm", (int)255, (String)"fieldLengthError", (Errors)errors);
        ValidatorUtils.rejectValueIfLonger((String)"description", (int)255, (String)"fieldLengthError", (Errors)errors);
        ValidatorUtils.rejectValueIfLonger((String)"artist", (int)255, (String)"fieldLengthError", (Errors)errors);
        ValidatorUtils.rejectValueIfLonger((String)"uploadedBy", (int)130, (String)"fieldLengthError", (Errors)errors);
        ValidatorUtils.rejectValueIfLonger((String)"copyright", (int)255, (String)"fieldLengthError", (Errors)errors);
        List categoryIds = command.getCategoryIds();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String licenseDt = StringUtils.trimToNull((String)command.getLicenseDt());
        if (licenseDt != null) {
            try {
                command.setLicenseDate(df.parse(licenseDt));
            }
            catch (ParseException ex) {
                errors.rejectValue("licenseDt", "invalidStartDateError");
            }
        }
        if ((licenseEndDt = StringUtils.trimToNull((String)command.getLicenseEndDt())) != null) {
            try {
                command.setLicenseEndDate(df.parse(licenseEndDt));
            }
            catch (ParseException ex) {
                errors.rejectValue("licenseEndDt", "invalidEndDateError");
            }
        }
        if (command.getLicenseDate() != null && command.getLicenseEndDate() != null && command.getLicenseDate().compareTo(command.getLicenseEndDate()) >= 1) {
            errors.rejectValue("licenseDt", "invalidStartDateError");
            errors.rejectValue("licenseEndDt", "invalidEndDateError");
        }
    }
}

