package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRolesRepository;
import com.imcode.imcms.addon.imagearchive.repository.RoleRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.RoleService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
@Transactional
public class RoleServiceImpl implements RoleService {
    private static final Log log = LogFactory.getLog(RoleService.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CategoryRolesRepository categoryRolesRepository;
    @Autowired
    private Facade facade;

    public List<Role> getRolesByCategoryId(int id) {
        List<CategoryRoles> categoryRolesList = categoryRolesRepository.findByCategoryId(id);
        List<Role> rolesResult = new ArrayList<Role>();
        for (CategoryRoles categoryRoles : categoryRolesList) {
            rolesResult.add(categoryRoles.getRole());
        }
        return rolesResult;
    }


    public List<Category> getUsableRoleCategories(Role role) {
        return getRoleCategories(role.getId(), true, false);
    }

    public List<Category> getUsableRoleCategories(Role... roles) {
        Set<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(getRoleCategories(role.getId(), true, false));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getUsableRoleCategories(int id) {
        return getRoleCategories(id, true, false);
    }

    public List<Category> getUsableRoleCategories(int... ids) {
        Set<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(getRoleCategories(id, true, false));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getChangeableRoleCategories(int id) {
        return getRoleCategories(id, false, true);
    }

    public List<Category> getChangeableRoleCategories(int... ids) {
        Set<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(getRoleCategories(id, false, true));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getChangeableRoleCategories(Role role) {
        return getRoleCategories(role.getId(), false, true);
    }

    public List<Category> getChangeableRoleCategories(Role... roles) {
        Set<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(getRoleCategories(role.getId(), false, true));
        }
        return new ArrayList<Category>(result);
    }


    public List<Category> getAllRoleCategories(int id) {
        return getRoleCategories(id, false, false);
    }

    private List<Category> getRoleCategories(int id, boolean needUsable, boolean needChangable) {
        Set<Category> categoriesResult = new HashSet<Category>();
        List<CategoryRoles> categoryRolesList = categoryRolesRepository.findByRoleId(id);

        for (CategoryRoles categoryRoles : categoryRolesList) {
            if ((needUsable ? categoryRoles.getCanUse() : true) &&
                    (needChangable ? categoryRoles.getCanChange() : true)) {
                categoriesResult.add(facade.getCategoryService().getCategory(categoryRoles.getCategoryId()));
            }
        }
        return new ArrayList<Category>(categoriesResult);
    }

    public Role getRoleById(int roleId) {
        return roleRepository.findOne(roleId);
    }

    public Role getRoleByName(String name) {
        return roleRepository.findByName(name);
    }

    public List<Role> getAllRoles() {
        return roleRepository.findAll();
    }

    public List<CategoryRoles> getCategoryRolesByRole(Role role) {
        return categoryRolesRepository.findByRoleId(role.getId());
    }

    public void assignCategoryRoles(final Role role, final List<SaveRoleCategoriesCommand.CategoryRight> categoryRights) {

        List<CategoryRoles> toDelete = categoryRolesRepository.findByRoleId(role.getId());

        for (CategoryRoles categoryRole : toDelete) {
            categoryRolesRepository.delete(categoryRole);
        }
        categoryRolesRepository.flush();

        if (categoryRights != null) {
            for (SaveRoleCategoriesCommand.CategoryRight categoryRight : categoryRights) {
                CategoryRoles cr = new CategoryRoles(categoryRight.getCategoryId(), role.getId(), categoryRight.isCanUse(), categoryRight.isCanEditOrAdd());
                categoryRolesRepository.save(cr);
            }
        }
        categoryRolesRepository.flush();
    }


//
//    @Autowired
//    private Facade facade;
//    @Autowired
//    private HibernateTemplate template;
//
//
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public Role findRoleById(int id) {
//        return (Role) template.get(Role.class, id);
//    }
//
//    @Transactional(readOnly = true)
//    public Role getRoleByName(final String roleName) {
//        return (Role) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.createCriteria(Role.class, "r")
//                        .add(Restrictions.eq("r.roleName", roleName))
//                        .uniqueResult();
//            }
//        });
//    }
//
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Role> getAllRoles() {
//        return (List<Role>) template.find("FROM Role r ORDER BY r.roleName");
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Category> findRoleCategories(int roleId) {
//        return (List<Category>) template.find(
//                "SELECT c FROM CategoryRoles cr JOIN cr.category c " +
//                        "WHERE cr.roleId = ? AND c.type.imageArchive IS TRUE ORDER BY c.name", roleId);
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Category> findFreeCategories(int roleId) {
//        return (List<Category>) template.find(
//                "SELECT c FROM Categories c WHERE " +
//                "NOT EXISTS (FROM CategoryRoles cr WHERE cr.roleId = ? AND cr.categoryId = c.id) " +
//                "AND c.type.imageArchive IS TRUE ORDER BY c.name", roleId);
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Category> findAllCategories() {
//
//        return (List<Category>) template.find("SELECT c FROM Categories c WHERE " +
//                "c.type.imageArchive IS TRUE ORDER BY c.name");
//    }
//
//    public void assignCategoryRoles(final Role role, final List<SaveRoleCategoriesCommand.CategoryRight> categoryRights) {
//        template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                List<CategoryRoles> toDelete = session.createCriteria(CategoryRoles.class, "cr")
//                        .add(Restrictions.eq("cr.roleId", role.getId()))
//                        .list();
//
//                for(CategoryRoles categoryRole: toDelete) {
//                    session.delete(categoryRole);
//                }
//                session.flush();
//
//                if(categoryRights != null) {
//                    for(SaveRoleCategoriesCommand.CategoryRight categoryRight: categoryRights) {
//                        CategoryRoles cr = new CategoryRoles(categoryRight.getCategoryId(), role.getId(), categoryRight.isCanUse(), categoryRight.isCanEditOrAdd());
//                            session.persist(cr);
//                    }
//                }
//                session.flush();
//
//                return null;
//            }
//        });
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Category> findCategories(final User user, final int... permissions) {
//        return (List<Category>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                Set<Integer> roleIds;
//                if (user == null) {
//                    roleIds = new HashSet<Integer>();
//                    roleIds.add(Role.USERS_ID);
//
//                } else if (user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade)) {
//                    return session.createQuery(
//                            "SELECT DISTINCT c.id AS id, c.name AS name FROM Categories c " +
//                            "WHERE c.type.imageArchive IS TRUE ORDER BY c.name")
//                            .setResultTransformer(Transformers.aliasToBean(Category.class))
//                            .list();
//
//                } else {
//                    roleIds = facade.getUserService().getRoleIdsWithPermission(user, null, permissions);
//                    if (roleIds.isEmpty()) {
//                        return Collections.EMPTY_LIST;
//                    }
//
//                }
//
//                return session.createQuery(
//                        "SELECT DISTINCT c.id AS id, c.name AS name FROM CategoryRoles cr INNER JOIN cr.category c " +
//                        "WHERE cr.roleId IN (:roleIds) AND c.type.imageArchive IS TRUE ORDER BY c.name")
//                        .setParameterList("roleIds", roleIds)
//                        .setResultTransformer(Transformers.aliasToBean(Category.class))
//                        .list();
//            }
//        });
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Integer> findCategoryIds(final User user, final int... permissions) {
//        return (List<Integer>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                Set<Integer> roleIds = facade.getUserService().getRoleIdsWithPermission(user, null, permissions);
//                if (roleIds.isEmpty()) {
//                    return Collections.EMPTY_LIST;
//                }
//
//                return session.createQuery(
//                        "SELECT cr.categoryId FROM CategoryRoles cr WHERE cr.roleId IN (:roleIds) AND cr.category.type.imageArchive IS TRUE ")
//                        .setParameterList("roleIds", roleIds)
//                        .list();
//            }
//        });
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Integer> findRoleIdsWithPermission(final int userId, final int rolePermissionMask) {
//        return (List<Integer>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                List<Role> roles = session.createQuery(
//                        "SELECT r.id AS id, r.permissions AS permissions FROM UserRoles ur INNER JOIN ur.role r " +
//                        "WHERE ur.userId = :userId ")
//                        .setInteger("userId", userId)
//                        .setResultTransformer(Transformers.aliasToBean(Role.class))
//                        .list();
//
//                List<Integer> roleIds = new ArrayList<Integer>();
//                for (Role role : roles) {
//                    if ((role.getPermissions() & rolePermissionMask) == rolePermissionMask) {
//                        roleIds.add(role.getId());
//                    }
//                }
//
//                return roleIds;
//            }
//        });
//    }
//
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public boolean hasAccessToCategory(final User user, final int categoryId, final int... permissions) {
//        return (Boolean) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                Set<Integer> roleIds;
//                if (user == null) {
//                    roleIds = new HashSet<Integer>();
//                    roleIds.add(Role.USERS_ID);
//
//                } else if (user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade)) {
//                    return true;
//
//                } else {
//                    List<Integer> categoryIds = new ArrayList<Integer>();
//                    categoryIds.add(categoryId);
//                    roleIds = facade.getUserService().getRoleIdsWithPermission(user, categoryIds, permissions);
//                    if (roleIds.isEmpty()) {
//                        return false;
//                    }
//                }
//
//                long count = (Long) session.createQuery(
//                        "SELECT count(cr.categoryId) FROM CategoryRoles cr " +
//                        "WHERE cr.categoryId = :categoryId AND cr.roleId IN (:roleIds) AND cr.category.type.imageArchive IS TRUE")
//                        .setInteger("categoryId", categoryId)
//                        .setParameterList("roleIds", roleIds)
//                        .uniqueResult();
//
//                return count != 0L;
//            }
//        });
//    }
//
//    public Role getUsersRole() {
//        return (Role) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.get(Role.class, Role.USERS_ID);
//            }
//        });
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<String> findArtists(final User user, final Facade facade) {
//        return (List<String>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                if(user != null && (user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade))) {
//                    return session.createCriteria(Exif.class, "exif")
//                            .add(Restrictions.eq("exif.type", Exif.TYPE_CHANGED))
//                            .add(Restrictions.ne("exif.artist", ""))
//                            .setProjection(Projections.distinct(Projections.property("exif.artist")))
//                            .list();
//                }
//
//                Set<Integer> roleIds;
//                if (user == null) {
//                    roleIds = new HashSet<Integer>(1);
//                    roleIds.add(Role.USERS_ID);
//                } else {
//                    roleIds = facade.getUserService().getRoleIdsWithPermission(user, null, Role.ALL_PERMISSIONS);
//                    if (roleIds.isEmpty()) {
//                        return Collections.EMPTY_LIST;
//                    }
//                }
//
//                return session
//                        .getNamedQuery("artistsByRoleIds")
//                        .setParameterList("roleIds", roleIds)
//                        .setShort("changedType", Exif.TYPE_CHANGED)
//                        .setInteger("userId", user != null ? user.getUserId() : -1)
//                        .list();
//            }
//        });
//    }
}
