package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.*;

@Entity
@Table(name = "users")
public class User implements Serializable {
    private static final long serialVersionUID = -5162741915332464869L;

    @Id
    @GeneratedValue
    @Column(name = "user_id", nullable = false)
    private long id;

    @Column(name = "login_name", length = 128, nullable = false, unique = true)
    private String loginName;

    @Column(name = "login_password", length = 15, nullable = false)
    private String loginPassword;

    @Column(name = "first_name", length = 64, nullable = false)
    private String firstName;

    @Column(name = "last_name", length = 64, nullable = false)
    private String lastName;

    @Column(name = "title", length = 64, nullable = false)
    private String title;

    @Column(name = "company", length = 64, nullable = false)
    private String company;

    @Column(name = "address", length = 128, nullable = false)
    private String address;

    @Column(name = "city", length = 64, nullable = false)
    private String city;

    @Column(name = "zip", length = 64, nullable = false)
    private String zip;

    @Column(name = "country", length = 64, nullable = false)
    private String country;

    @Column(name = "county_council", length = 128, nullable = false)
    private String countyCouncil;

    @Column(name = "email", length = 128, nullable = false)
    private String email;

    @Column(name = "`external`", nullable = false)
    private boolean external;

    @Column(name = "active", nullable = false)
    private boolean active = true;

    @Column(name = "create_date", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date createDate;

    @Column(name = "language", length = 3, nullable = false)
    private String language;

    @Column(name = "session_id", length = 128)
    private String sessionId;

    @Column(name = "remember_cd", length = 40, unique = true)
    private String rememberCd;

    @OneToMany(fetch = FetchType.EAGER)
    @JoinTable(
            name = "user_roles_crossref",
            joinColumns = @JoinColumn(name = "user_id", nullable = false, insertable = false, updatable = false, unique = true),
            inverseJoinColumns = @JoinColumn(name = "role_id", nullable = false, insertable = false, updatable = false, unique = true))
    private Set<Role> roles;

    @Transient
    private List<Integer> roleIds = Collections.emptyList();


    public User() {
    }


    public boolean isSuperadmin() {
        for (Role role : roles) {
            if (role.isSuperadmin()) {
                return true;
            }
        }

        return false;
    }

    public boolean isCanChangeImage() {
        for (Role role : roles) {
            if (role.isCanChangeImage()) {
                return true;
            }
        }

        return false;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountyCouncil() {
        return countyCouncil;
    }

    public void setCountyCouncil(String countyCouncil) {
        this.countyCouncil = countyCouncil;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isExternal() {
        return external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getLoginPassword() {
        return loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getId() {
        return id;
    }

    public void setId(long userId) {
        this.id = userId;
    }

    public String getZip() {
        return zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public boolean hasRole(Role role) {
        return getRoles().contains(role);
    }

    public Set<Role> getRoles() {
        return roles;
    }

    public void setRoles(Set<Role> roles) {
        if (roles != null) {
            roleIds = new ArrayList<Integer>(roles.size());
            for (Role role : roles) {
                roleIds.add(role.getId());
            }
        }

        this.roles = roles;
    }

    public String getRememberCd() {
        return rememberCd;
    }

    public void setRememberCd(String rememberCd) {
        this.rememberCd = rememberCd;
    }

    public List<Integer> getRoleIdsWithPermission(int... permissions) {
        List<Integer> ids = new ArrayList<Integer>();

        for (Role role : roles) {
            for (int permission : permissions) {
                if ((role.getPermissions() & permission) == permission) {
                    ids.add(role.getId());
                    break;
                }
            }
        }

        return ids;
    }

    public List<Integer> getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(List<Integer> roleIds) {
        this.roleIds = roleIds;
    }


    @Override
    public boolean equals(Object obj) {
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }

        final User other = (User) obj;
        return this.id == other.id;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = (int) (37 * hash + this.id);

        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.User[userId: %d, loginName: %s]", id, loginName);
    }
}
