/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.entity;

import com.imcode.imcms.addon.imagearchive.entity.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="users")
public class User
implements Serializable {
    private static final long serialVersionUID = -5162741915332464869L;
    @Id
    @GeneratedValue
    @Column(name="user_id", nullable=false)
    private long id;
    @Column(name="login_name", length=128, nullable=false, unique=true)
    private String loginName;
    @Column(name="login_password", length=15, nullable=false)
    private String loginPassword;
    @Column(name="first_name", length=64, nullable=false)
    private String firstName;
    @Column(name="last_name", length=64, nullable=false)
    private String lastName;
    @Column(name="title", length=64, nullable=false)
    private String title;
    @Column(name="company", length=64, nullable=false)
    private String company;
    @Column(name="address", length=128, nullable=false)
    private String address;
    @Column(name="city", length=64, nullable=false)
    private String city;
    @Column(name="zip", length=64, nullable=false)
    private String zip;
    @Column(name="country", length=64, nullable=false)
    private String country;
    @Column(name="county_council", length=128, nullable=false)
    private String countyCouncil;
    @Column(name="email", length=128, nullable=false)
    private String email;
    @Column(name="`external`", nullable=false)
    private boolean external;
    @Column(name="active", nullable=false)
    private boolean active = true;
    @Column(name="create_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createDate;
    @Column(name="language", length=3, nullable=false)
    private String language;
    @Column(name="session_id", length=128)
    private String sessionId;
    @Column(name="remember_cd", length=40, unique=true)
    private String rememberCd;
    @OneToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_roles_crossref", joinColumns={@JoinColumn(name="user_id", nullable=false, insertable=false, updatable=false, unique=true)}, inverseJoinColumns={@JoinColumn(name="role_id", nullable=false, insertable=false, updatable=false, unique=true)})
    private Set<Role> roles;
    @Transient
    private List<Integer> roleIds = Collections.emptyList();

    public boolean isSuperadmin() {
        for (Role role : this.roles) {
            if (!role.isSuperadmin()) continue;
            return true;
        }
        return false;
    }

    public boolean isCanChangeImage() {
        for (Role role : this.roles) {
            if (!role.isCanChangeImage()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountyCouncil() {
        return this.countyCouncil;
    }

    public void setCountyCouncil(String countyCouncil) {
        this.countyCouncil = countyCouncil;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long userId) {
        this.id = userId;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public boolean hasRole(Role role) {
        return this.getRoles().contains(role);
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        if (roles != null) {
            this.roleIds = new ArrayList<Integer>(roles.size());
            for (Role role : roles) {
                this.roleIds.add(role.getId());
            }
        }
        this.roles = roles;
    }

    public String getRememberCd() {
        return this.rememberCd;
    }

    public void setRememberCd(String rememberCd) {
        this.rememberCd = rememberCd;
    }

    public List<Integer> getRoleIdsWithPermission(int ... permissions) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        block0: for (Role role : this.roles) {
            for (int permission : permissions) {
                if ((role.getPermissions() & permission) != permission) continue;
                ids.add(role.getId());
                continue block0;
            }
        }
        return ids;
    }

    public List<Integer> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<Integer> roleIds) {
        this.roleIds = roleIds;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = (int)((long)(37 * hash) + this.id);
        return hash;
    }

    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.User[userId: %d, loginName: %s]", this.id, this.loginName);
    }
}

