/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.ImcmsImageService;
import com.imcode.imcms.addon.imagearchive.service.RoleService;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImcmsImageServiceImpl
implements ImcmsImageService {
    private static final Log log = LogFactory.getLog(RoleService.class);
    @Autowired
    private Facade facade;

    @Override
    public String storeImage(byte[] imageInBytes, long imageId) {
        String filename = String.format("archive_img%d.jpg", imageId);
        File imcmsFile = new File(this.facade.getConfig().getImcmsImagesPath(), filename);
        try {
            FileUtils.writeByteArrayToFile((File)imcmsFile, (byte[])imageInBytes);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            imcmsFile.delete();
            return null;
        }
        return filename;
    }
}

