<%@ include file="/WEB-INF/includes/taglibs.jspf" %>
<spring:message var="title" code="title.addImage" htmlEscape="true"/>
<spring:message var="pageHeading" code="pageHeading.addImage" htmlEscape="true"/>
<c:set var="currentPage" value="addImage"/>
<c:set var="css">
    <link rel="stylesheet" type="text/css" href="${contextPath}/jscalendar/skins/aqua/theme.css"/>
    <link rel="stylesheet" type="text/css" href="${contextPath}/js/jquery.uploadify-v2.1.4/uploadify.css"/>
</c:set>
<c:set var="javascript">
    <script type="text/javascript" src="${contextPath}/jscalendar/calendar.js"></script>
    <script type="text/javascript" src="${contextPath}/jscalendar/lang/calendar-${locale.language}.js"></script>
    <script type="text/javascript" src="${contextPath}/jscalendar/calendar-setup.js"></script>

    <script type="text/javascript">
        $(initAddImage);
    </script>
</c:set>
<%@ include file="/WEB-INF/includes/header.jsp" %>
<%@ include file="/WEB-INF/includes/top.jsp" %>

<div id="containerContent">
    <c:url var="uploadUrl" value="/archive/add-image/upload"/>
    <form:form commandName="upload" action="${uploadUrl}" method="post" enctype="multipart/form-data" cssClass="m15t clearfix">
        <div class="addImageControls clearfix">
            <label for="uploadify" class="left" style="margin:3px 20px 3px 0;">
                <spring:message code="addImage.selectImage" htmlEscape="true"/>
            </label>
            <div class="UploadifyButtonWrapper">
                <button type="button" class="imcmsFormBtn"><spring:message code="addImage.browse" htmlEscape="true"/></button>
                <div class="UploadifyObjectWrapper">
                    <input id="uploadify" type="file" name="file"/>
                </div>
            </div>
            <spring:message var="uploadText" code="addImage.upload" htmlEscape="true"/>
        </div>
    </form:form>
    <div class="clearfix">
        <h4 class="imcmsAdmHeading"><spring:message code="addImage.selectedImages" htmlEscape="true"/></h4>
        <div id="uploadifyQueue" class="uploadifyQueue"></div>
        <div id='multiUploadData'>
            <c:if test='${image eq null}'>
                <jsp:include page="/WEB-INF/jsp/fragments/multi_file_data.jsp"/>
            </c:if>
        </div>
    </div>
</div>

<%@ include file="/WEB-INF/includes/footer.jsp" %>