package com.imcode.imcms.addon.imagearchive;

import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.service.KeywordService;
import org.apache.commons.collections.BidiMap;
import org.springframework.context.support.GenericXmlApplicationContext;

import java.io.File;
import java.util.List;

public class Config {
    private static File applicationPath;

    private File storagePath;
    private File tempPath;
    private File imageMagickPath;
    private String imcmsRootUrl;
    private String imcmsLoginUrlPath;
    private File imcmsImagesPath;
    private File imcmsLibrariesPath;
    private String imcmsUsersLibraryFolder;
    private File[] imcmsOldLibraryPaths;
    private BidiMap languages;

    private long maxImageUploadSize;
    private long maxZipUploadSize;

    private String accessCode;

//    private String serverAddress = "http://localhost:8081/api/";

    public Config() {
    }

    public String getAccessCode() {
        return accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public long getMaxImageUploadSize() {
        return maxImageUploadSize;
    }

    public void setMaxImageUploadSize(long maxImageUploadSize) {
        this.maxImageUploadSize = maxImageUploadSize;
    }

    public long getMaxZipUploadSize() {
        return maxZipUploadSize;
    }

    public void setMaxZipUploadSize(long maxZipUploadSize) {
        this.maxZipUploadSize = maxZipUploadSize;
    }

    public String getImcmsRootUrl() {
        return imcmsRootUrl;
    }

    public void setImcmsRootUrl(String imcmsRootUrl) {
        this.imcmsRootUrl = imcmsRootUrl;
    }

    public File getStoragePath() {
        return storagePath;
    }

    public void setStoragePath(File storagePath) {
        this.storagePath = storagePath;
    }

    public File getTempPath() {
        return tempPath;
    }

    public void setTempPath(File tempPath) {
        this.tempPath = tempPath;
    }

    public File getImageMagickPath() {
        return imageMagickPath;
    }

    public void setImageMagickPath(File imageMagickPath) {
        this.imageMagickPath = imageMagickPath;
    }

    public String getImcmsLoginUrlPath() {
        return imcmsLoginUrlPath;
    }

    public void setImcmsLoginUrlPath(String imcmsLoginUrlPath) {
        this.imcmsLoginUrlPath = imcmsLoginUrlPath;
    }

    public File getImcmsImagesPath() {
        return imcmsImagesPath;
    }

    public void setImcmsImagesPath(File imcmsImagesPath) {
        this.imcmsImagesPath = imcmsImagesPath;
    }

    public File getImcmsLibrariesPath() {
        return imcmsLibrariesPath;
    }

    public void setImcmsLibrariesPath(File imcmsLibrariesPath) {
        this.imcmsLibrariesPath = imcmsLibrariesPath;
    }

    public String getImcmsUsersLibraryFolder() {
        return imcmsUsersLibraryFolder;
    }

    public void setImcmsUsersLibraryFolder(String imcmsUsersLibraryFolder) {
        this.imcmsUsersLibraryFolder = imcmsUsersLibraryFolder;
    }

    public File[] getImcmsOldLibraryPaths() {
        return imcmsOldLibraryPaths;
    }

    public void setImcmsOldLibraryPaths(File[] imcmsOldLibraryPaths) {
        this.imcmsOldLibraryPaths = imcmsOldLibraryPaths;
    }

    public BidiMap getLanguages() {
        return languages;
    }

    public void setLanguages(BidiMap languages) {
        this.languages = languages;
    }

    public static File getApplicationPath() {
        return applicationPath;
    }

    public static void setApplicationPath(File appPath) {
        applicationPath = appPath;
    }

//    public String getServerAddress() {
//        return serverAddress;
//    }
//
//    public void setServerAddress(String serverAddress) {
//        this.serverAddress = serverAddress;//    }

    //    public static void main(String[] args) {
//        String url = "http://localhost:8080/archive";
//        RestTemplate restTemplate = new RestTemplate();
//
//        Resource resource = new FileSystemResource("/home/vitaly/SkypeFiles/350px-Slab_i_otvaga.jpg");
////        HttpHeaders partHeaders = new HttpHeaders();
////        partHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
////        HttpEntity<Resource> resourceHttpEntity = new HttpEntity<Resource>(resource, partHeaders);
//
//
//        Image image = new Image();
//        image.setImageNm("asdfasdfas");
//
//        MultiValueMap<String, Object> parts = new LinkedMultiValueMap<String, Object>();
//        parts.add("file", resource);
//        parts.add("image", image);
//
//        String result = restTemplate.postForObject(url, parts, String.class);
////        String result = restTemplate.postForObject(url, image, String.class);
//
//        System.out.println(result);
////        System.out.println(Integer.toBinaryString(-1).length());
////        printBinaryInt(Integer.MIN_VALUE);
//    }
//
    public static void main(String[] args) {
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext();
        ctx.load("classpath:spring/test.xml");
        ctx.refresh();
        KeywordService keywordService = ctx.getBean("remoteKeywordService", KeywordService.class);
        List<Keyword> keywords = keywordService.getKeywords();
        System.out.println(keywords);

//        String url = "http://localhost:8080/api/test/archive";
//        RestTemplate restTemplate = new RestTemplate();
//
////        Resource resource = new FileSystemResource("/home/vitaly/SkypeFiles/350px-Slab_i_otvaga.jpg");
////        HttpHeaders partHeaders = new HttpHeaders();
////        partHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
////        HttpEntity<Resource> resourceHttpEntity = new HttpEntity<Resource>(resource, partHeaders);
//
//
////        Image image = new Image();
////        image.setImageNm("asdfasdfas");
////
//        MultiValueMap<String, Object> parts = new LinkedMultiValueMap<String, Object>();
////        parts.add("file", resource);
////        parts.add("image", image);
//
//        FakeModelAndView result = restTemplate.getForObject(url, FakeModelAndView.class);
////        String result = restTemplate.postForObject(url, image, String.class);
//
//        System.out.println(result);
////        System.out.println(Integer.toBinaryString(-1).length());
////        printBinaryInt(Integer.MIN_VALUE);
    }

//    public static void printBinaryInt(int i) {
//        System.out.printf("(%d)%s", i, Integer.toBinaryString(i));
//    }
}
