<%@ include file="/WEB-INF/includes/taglibs.jspf" %>
<spring:message var="notAvailable" code="changeData.notAvailable"/>

<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.imageName" htmlEscape="true"/>
    </span>
    <span class="infoValue"><c:out value="${image.name}"/></span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.description" htmlEscape="true"/>
    </span>
    <p class="infoValue">
        <c:choose>
            <%--<c:when test="${not empty image.exif.description}">--%>
                <%--${im:newlineToBr(fn:escapeXml(image.exif.description))}--%>
            <%--</c:when>--%>
            <c:when test="${not empty image.exif.description}">
                ${im:newlineToBr(fn:escapeXml(image.exif.description))}
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </p>
</div>
<div class="infoRow clearfix odd">
    <span class="infoLabel">
        <spring:message code="changeData.category" htmlEscape="true"/>
    </span>
    <p class="infoValue">
        <c:choose>
            <c:when test="${not empty categories}">
                <c:out value="${categories}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </p>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.keywords" htmlEscape="true"/>
    </span>
    <p class="infoValue">
        <c:choose>
            <c:when test="${not empty keywords}">
                <c:out value="${keywords}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </p>
</div>
<div class="infoRow clearfix odd">
    <span class="infoLabel">
        <spring:message code="changeData.photographer" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <%--<c:when test="${not empty image.exif.artist}">--%>
                <%--<c:out value="${image.exif.artist}"/>--%>
            <%--</c:when>--%>
            <c:when test="${not empty image.exif.artist}">
                <c:out value="${image.exif.artist}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.originalSizeWidth" htmlEscape="true"/>
    </span>
    <span class='infoValue'>
        ${image.width}x${image.height}
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.resolution" htmlEscape="true"/>
    </span>
    <span class='infoValue'>
        <c:choose>
            <c:when test="${empty image.exif.xResolution and empty image.exif.yResolution}">
                <c:out value="${notAvailable}"/>
            </c:when>
            <c:otherwise>
                <c:set var="xResolution" value="${empty image.exif.xResolution ? notAvailable : image.exif.xResolution}"/>
                <c:set var="yResolution" value="${empty image.exif.yResolution ? notAvailable : image.exif.yResolution}"/>
                <c:choose>
                    <c:when test="${3 eq image.exif.resolutionUnit}">
                        <spring:message code="changeData.xResolutionYResolutionDPCM" arguments="${xResolution}, ${yResolution}" htmlEscape="true"/>
                    </c:when>
                    <c:when test="${2 eq image.exif.resolutionUnit}">
                        <spring:message code="changeData.xResolutionYResolutionDPI" arguments="${xResolution}, ${yResolution}" htmlEscape="true"/>
                    </c:when>
                    <c:otherwise>
                        <spring:message code="changeData.xResolutionYResolutionUnknown" arguments="${xResolution}, ${yResolution}" htmlEscape="true"/>
                    </c:otherwise>
                </c:choose>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.originalFileSize" htmlEscape="true"/>
    </span>
    <span class='infoValue'><spring:message code="originalSizeKb" arguments="${image.fileSize / 1024.0}"/></span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.originalFileType" htmlEscape="true"/>
    </span>
    <span class='infoValue'><c:out value="${format.format}"/></span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.id" htmlEscape="true"/>
    </span>
    <span class='infoValue'>${image.id}</span>
</div>
<%--<div class="infoRow odd clearfix">--%>
    <%--<span class="infoLabel">--%>
        <%--<spring:message code="usedInImcms" htmlEscape="true"/>--%>
    <%--</span>--%>
    <%--<span class='infoValue'>${im:join(image.metaIds, ', ')}</span>--%>
<%--</div>--%>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.uploadedBy" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:out value="${image.uploadedBy}"/>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.copyright" htmlEscape="true"/>
    </span>
    <span class='infoValue'>
        <c:choose>
            <c:when test="${not empty image.exif.copyright}">
                <c:out value="${image.exif.copyright}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.licensePeriod" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${image.licenseDt ne null and image.licenseEndDt ne null}">
                <c:choose>
                    <c:when test="${image.licenseDt ne null}">
                        <spring:message code="dateFormat" arguments="${image.licenseDt}" htmlEscape="true"/>
                    </c:when>
                    <c:otherwise>
                        <c:out value="${notAvailable}"/>
                    </c:otherwise>
                </c:choose>
                &#8211;
                <c:choose>
                    <c:when test="${image.licenseEndDt ne null}">
                        <spring:message code="dateFormat" arguments="${image.licenseEndDt}" htmlEscape="true"/>
                    </c:when>
                    <c:otherwise>
                        <c:out value="${notAvailable}"/>
                    </c:otherwise>
                </c:choose>
            </c:when>
            <c:otherwise>
                <c:out value="${notAvailable}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>
<div class="infoRow odd clearfix">
    <span class="infoLabel">
        <spring:message code="changeData.altText" htmlEscape="true"/>
    </span>
    <span class="infoValue">
        <c:choose>
            <c:when test="${empty image.altText}">
                <c:out value="${notAvailable}"/>
            </c:when>
            <c:otherwise>
                <c:out value="${image.altText}"/>
            </c:otherwise>
        </c:choose>
    </span>
</div>