<%@ include file="/WEB-INF/includes/taglibs.jspf" %>
<c:if test="${user ne null and not image.archived}">
    <div class="imcmsAdmForm" id="exportOverlay">
        <h4 class="imcmsAdmHeading"><spring:message code="imageCard.export.exportImage" htmlEscape="true"/></h4>
        <c:url var="exportUrl" value="/archive/image/${image.id}"/>
        <form:form action="${exportUrl}" commandName="exportImage" method="post" cssClass="right">
            <div class="clearfix minH30">
                <label for="width" class="left fixedWidth">
                    <spring:message code="imageCard.export.width" htmlEscape="true"/>
                </label>
                <div class="left">
                    <form:input id="width" path="width" cssClass="left fixedWidthInput"/>
                </div>
                <div class="left" style="margin-left: 10px;">
                    <form:select id="sizeUnit" path="sizeUnit" items="${exportImage.sizeUnits}" itemLabel="unitName"/>
                </div>
            </div>

            <div class="clearfix minH30">
                <label for="height" class="left fixedWidth">
                    <spring:message code="imageCard.export.height" htmlEscape="true"/>
                </label>
                <div class="left">
                    <form:input id="height" path="height" cssClass="left fixedWidthInput"/>
                </div>
            </div>

            <div class="clearfix minH30">
                <div class="left fixedWidth">&nbsp;</div>
                <div class="left">
                    <form:checkbox id="keepAspectRatio" path="keepAspectRatio"/>
                    <label for="keepAspectRatio">
                        <spring:message code="imageCard.export.keepAspectRatio" htmlEscape="true"/>
                    </label>
                </div>
            </div>

            <div class="clearfix minH30">
                <label for="fileFormat" class="left fixedWidth">
                    <spring:message code="imageCard.export.fileFormat" htmlEscape="true"/>
                </label>
                <select id="fileFormat" name="fileFormat" class="left fixedWidthInput">
                    <c:forEach var="format" items="${exportImage.fileFormats}">
                        <option value="${format.ordinal}" ${exportImage.fileFormat eq format.ordinal ? 'selected="selected"' : ''} >
                            <c:out value="${fn:toLowerCase(format.format)}"/>
                        </option>
                    </c:forEach>
                </select>
            </div>

            <div class="clearfix minH30">
                <label for="quality" class="left fixedWidth">
                    <spring:message code="imageCard.export.quality" htmlEscape="true"/>
                </label>
                <select id="quality" name="quality" class="left fixedWidthInput">
                    <c:forEach var="quality" items="${exportImage.qualities}">
                        <option value="${quality}" ${exportImage.quality eq quality ? 'selected="selected"' : ''} >${quality}%</option>
                    </c:forEach>
                </select>
            </div>

            <div class="exportBtns">
                <spring:message var="exportText" code="imageCard.export.exportButton" htmlEscape="true"/>
                <spring:message var="cancelText" code="cancel" htmlEscape="true"/>
                <input type="button" class="imcmsFormBtn" name="cancel" value="${cancelText}" id="exportDialogCloseBtn"/>
                <input type="submit" class="imcmsFormBtn" name="export" value="${exportText}" id="exportDialogSubmit"/>
            </div>
        </form:form>
    </div>
</c:if>