package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;

import java.util.List;

/**
 * Created by Shadowgun on 13.05.2015.
 */
public interface RoleService {
    public Role getRoleById(int roleId);

    public Role getRoleByName(String name);

    public List<Role> getAllRoles();

    public List<CategoryRoles> getCategoryRolesByRole(Role role);

    public List<Role> getRolesByCategoryId(int id);

    public List<Category> getAllRoleCategories(int id);

    public List<Category> getUsableRoleCategories(int id);

    public List<Category> getUsableRoleCategories(int... id);

    public List<Category> getChangeableRoleCategories(int id);

    public List<Category> getChangeableRoleCategories(int... id);

    public List<Category> getUsableRoleCategories(Role role);

    public List<Category> getUsableRoleCategories(Role... roles);

    public List<Category> getChangeableRoleCategories(Role role);

    public List<Category> getChangeableRoleCategories(Role... roles);

    public void assignCategoryRoles(Role role, List<SaveRoleCategoriesCommand.CategoryRight> categoryRights);

}
