package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
//import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Locale;

public class AccessFilter implements Filter {
    private static final Log log = LogFactory.getLog(AccessFilter.class);
    
    private FilterConfig filterConfig = null;
    private Facade facade;
    
    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = context.getBean(Facade.class);
    }
    
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        fixUTF8(request, response);

        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;

//      Disabled due to param encoding already being set in tomcat settings.
//        if ("GET".equals(httpRequest.getMethod())) {
//            httpRequest = new UTF8RequestWrapper(httpRequest);
//        }

//        User user = doLogin(httpRequest);
        setLocale(httpRequest, httpResponse);
        setRequestUrl(httpRequest);

        chain.doFilter(httpRequest, httpResponse);
    }
    
//    private User doLogin(HttpServletRequest request) {
//        HttpSession session = request.getSession();
//        User user = (User) session.getAttribute(SessionConstants.USER);
//
//        Cookie[] cookies = request.getCookies();
//        if (cookies != null) {
//            for (Cookie cookie : cookies) {
//                if (cookie.getName().equals("im_remember_cd")) {
//                    String cd = cookie.getValue();
//
//                    if (user != null && cd.equals(user.getRememberCd())) {
//                        return user;
//                    }
//
//                    user = facade.getUserService().findUserByRememberCd(cd);
//
//                    if (user != null) {
//                        session.invalidate();
//                        session = request.getSession();
//                        session.setAttribute(SessionConstants.USER, user);
//                    } else {
//                        session.removeAttribute(SessionConstants.USER);
//                    }
//
//                    return user;
//                }
//            }
//        }
//
//        return null;
//    }
    
    private void setLocale(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Locale locale = (Locale) session.getAttribute(SessionConstants.LOCALE);
        if (locale != null) {
            return;
        }
        
        BidiMap languages = facade.getConfig().getLanguages();
        
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals("im_lang")) {
                    if (languages.containsValue(cookie.getValue())) {
                        locale = new Locale(cookie.getValue());
                    }
                    break;
                }
            }
        }
        
//        if (locale == null && user != null) {
        if (locale == null) {
            String lang = "en";
//            (String) languages.get(user.getLanguage());
            if (lang != null) {
                locale = new Locale(lang);
            }
        }
        
        if (locale == null) {
            locale = new Locale("en");
        }
        
        session.setAttribute(SessionConstants.LOCALE, locale);
        session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, locale);
        request.setAttribute("locale", locale);
    }
    
    private void setRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        
        if (queryString != null) {
            url += "?" + queryString;
        }
        
        request.setAttribute("requestUrl", url);
    }
    
    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
    
    public void destroy() {
    }
}
