/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util.image;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.util.image.ByteArrayInputStreamHandler;
import com.imcode.imcms.addon.imagearchive.util.image.Color;
import com.imcode.imcms.addon.imagearchive.util.image.Filter;
import com.imcode.imcms.addon.imagearchive.util.image.Format;
import com.imcode.imcms.addon.imagearchive.util.image.Gravity;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.Resize;
import com.imcode.imcms.addon.imagearchive.util.image.StringInputStreamHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageOp {
    private static final Log log = LogFactory.getLog(ImageOp.class);
    private static final boolean PLATFORM_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("format:'([^']+)'");
    private static final Pattern WIDTH_PATTERN = Pattern.compile("width:'([^']+)'");
    private static final Pattern HEIGHT_PATTERN = Pattern.compile("height:'([^']+)'");
    private List<String> args = new ArrayList<String>();
    private byte[] inputData;
    private InputStream dataStream;
    private Format outputFormat;

    public ImageOp(Config config) {
        this.args.add(ImageOp.addQuotes(ImageOp.getApplicationPath(config, "convert")));
        log.debug((Object)("Args: " + this.args));
    }

    private static final String getApplicationPath(Config config, String appName) {
        File magickPath = config.getImageMagickPath();
        if (magickPath != null) {
            log.debug((Object)magickPath);
            return new File(magickPath, appName).getAbsolutePath();
        }
        return appName;
    }

    private static final String addQuotes(String input) {
        if (PLATFORM_WINDOWS) {
            return "\"" + input + "\"";
        }
        return input;
    }

    public ImageOp input(byte[] data) {
        this.inputData = data;
        this.args.add("-[0]");
        return this;
    }

    public ImageOp input(InputStream input) {
        this.dataStream = input;
        this.args.add(ImageOp.addQuotes("-[0]"));
        return this;
    }

    public ImageOp input(File file) {
        this.args.add(ImageOp.addQuotes(file.getAbsolutePath() + "[0]"));
        log.debug((Object)("Args: " + this.args));
        return this;
    }

    public ImageOp filter(Filter filter) {
        this.args.add("-filter");
        this.args.add(ImageOp.addQuotes(filter.getFilter()));
        return this;
    }

    public ImageOp strip() {
        this.args.add("-strip");
        return this;
    }

    public ImageOp size(int width, int height) {
        this.args.add("-size");
        this.args.add(ImageOp.addQuotes(String.format("%dx%d", width, height)));
        return this;
    }

    public ImageOp rawImage(Color color, int width, int height) {
        this.size(width, height);
        this.args.add(ImageOp.addQuotes("xc:" + color.getColor()));
        return this;
    }

    public ImageOp swap(int index1, int index2) {
        this.args.add("-swap");
        this.args.add(ImageOp.addQuotes(String.format("%d,%d", index1, index2)));
        return this;
    }

    public ImageOp swapLastTwo() {
        this.args.add("+swap");
        return this;
    }

    public ImageOp composite() {
        this.args.add("-composite");
        return this;
    }

    public ImageOp gravity(Gravity gravity) {
        this.args.add("-gravity");
        this.args.add(ImageOp.addQuotes(gravity.getGravity()));
        return this;
    }

    public ImageOp quality(int quality) {
        quality = Math.max(quality, 0);
        quality = Math.min(quality, 100);
        this.args.add("-quality");
        this.args.add(ImageOp.addQuotes(Integer.toString(quality, 10)));
        return this;
    }

    public ImageOp rotate(int angle) {
        this.args.add("-rotate");
        this.args.add(ImageOp.addQuotes(Integer.toString(angle)));
        return this;
    }

    public ImageOp resize(Integer width, Integer height, Resize type) {
        this.args.add("-resize");
        String size = "";
        if (width != null) {
            size = width.toString();
        }
        if (height != null) {
            size = size + String.format("x%d", (int)height);
        }
        size = size + type.getModifier();
        this.args.add(ImageOp.addQuotes(size));
        return this;
    }

    public ImageOp resizeProportional(int width, int height, Color backgroundColor, Gravity gravity) {
        this.filter(Filter.LANCZOS);
        this.resize(width, height, Resize.GREATER_THAN);
        this.rawImage(backgroundColor, width, height);
        this.swapLastTwo();
        this.gravity(Gravity.CENTER);
        this.composite();
        return this;
    }

    public ImageOp outputFormat(Format format) {
        this.outputFormat = format;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processToByteArray() {
        block6: {
            String out = this.outputFormat != null ? this.outputFormat.getFormat() + ":-" : "-";
            ArrayList<String> arguments = new ArrayList<String>(this.args);
            arguments.add(ImageOp.addQuotes(out));
            try {
                Process process = new ProcessBuilder(arguments).start();
                StringInputStreamHandler errorHandler = new StringInputStreamHandler(process.getErrorStream());
                ByteArrayInputStreamHandler dataHandler = new ByteArrayInputStreamHandler(process.getInputStream());
                errorHandler.start();
                dataHandler.start();
                this.copyData(process);
                if (process.waitFor() != 0) {
                    errorHandler.join();
                    log.error((Object)errorHandler.getData());
                    break block6;
                }
                errorHandler.join();
                dataHandler.join();
                byte[] byArray = dataHandler.getData();
                return byArray;
            }
            catch (Exception ex) {
                log.fatal((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.dataStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processToFile(File outputFile) {
        block8: {
            log.debug((Object)("Start " + ImageOp.class.getSimpleName() + ".processToFile"));
            String out = null;
            out = this.outputFormat != null ? this.outputFormat.getFormat() + ":" + outputFile.getAbsolutePath() : outputFile.getAbsolutePath();
            ArrayList<String> arguments = new ArrayList<String>(this.args);
            arguments.add(ImageOp.addQuotes(out));
            try {
                log.debug((Object)("ProcessBuilder arguments : " + arguments));
                Process process = new ProcessBuilder(arguments).start();
                StringInputStreamHandler errorHandler = new StringInputStreamHandler(process.getErrorStream());
                errorHandler.start();
                this.copyData(process);
                if (process.waitFor() != 0) {
                    errorHandler.join();
                    log.error((Object)("Exception " + ImageOp.class.getSimpleName() + ".processToFile in imageMagic process"));
                    log.error((Object)errorHandler.getData());
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    break block8;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                log.fatal((Object)ex.getMessage(), (Throwable)ex);
                if (outputFile.exists()) {
                    outputFile.delete();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.dataStream);
            }
        }
        return false;
    }

    private void copyData(Process process) throws IOException {
        if (this.inputData != null || this.dataStream != null) {
            BufferedOutputStream output = null;
            try {
                output = new BufferedOutputStream(process.getOutputStream());
                if (this.inputData != null) {
                    ((OutputStream)output).write(this.inputData);
                } else if (this.dataStream != null) {
                    IOUtils.copy((InputStream)this.dataStream, (OutputStream)output);
                }
                IOUtils.closeQuietly((InputStream)this.dataStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo getImageInfo(Config config, InputStream inputStream) {
        try {
            Process process = new ProcessBuilder(ImageOp.getIdentifyProcessArgs(config, "-[0]")).start();
            StringInputStreamHandler errorHandler = new StringInputStreamHandler(process.getErrorStream());
            StringInputStreamHandler inputHandler = new StringInputStreamHandler(process.getInputStream());
            errorHandler.start();
            inputHandler.start();
            OutputStream output = null;
            try {
                output = process.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            inputHandler.join();
            ImageInfo imageInfo = ImageOp.processImageInfo(inputHandler);
            return imageInfo;
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    public static ImageInfo getImageInfo(Config config, File file) {
        try {
            String fileToIdentify = ImageOp.addQuotes(file.getAbsolutePath() + "[0]");
            Process process = new ProcessBuilder(ImageOp.getIdentifyProcessArgs(config, fileToIdentify)).start();
            StringInputStreamHandler errorHandler = new StringInputStreamHandler(process.getErrorStream());
            StringInputStreamHandler inputHandler = new StringInputStreamHandler(process.getInputStream());
            errorHandler.start();
            inputHandler.start();
            inputHandler.join();
            return ImageOp.processImageInfo(inputHandler);
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static String[] getIdentifyProcessArgs(Config config, String ... arguments) {
        String[] args = null;
        int startIndex = 1;
        args = new String[4 + arguments.length];
        args[0] = ImageOp.addQuotes(ImageOp.getApplicationPath(config, "identify"));
        args[startIndex] = "-quiet";
        args[startIndex + 1] = "-format";
        args[startIndex + 2] = "format:'%m'width:'%w'height:'%h'";
        for (int i = 0; i < arguments.length; ++i) {
            args[startIndex + 3 + i] = arguments[i];
        }
        return args;
    }

    private static ImageInfo processImageInfo(StringInputStreamHandler inputHandler) throws InterruptedException {
        if (inputHandler.getData() != null) {
            String input = inputHandler.getData();
            Matcher formatMatcher = FORMAT_PATTERN.matcher(input);
            Format format = null;
            if (formatMatcher.find()) {
                format = Format.findFormat(formatMatcher.group(1));
            }
            Matcher widthMatcher = WIDTH_PATTERN.matcher(input);
            int width = 0;
            if (widthMatcher.find()) {
                try {
                    width = Integer.parseInt(widthMatcher.group(1), 10);
                }
                catch (Exception ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            Matcher heightMatcher = HEIGHT_PATTERN.matcher(input);
            int height = 0;
            if (heightMatcher.find()) {
                try {
                    height = Integer.parseInt(heightMatcher.group(1), 10);
                }
                catch (Exception ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (format == null) {
                return null;
            }
            return new ImageInfo(format, width, height);
        }
        return null;
    }
}

