package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.*;
import java.util.Map;

//import com.imcode.imcms.addon.imagearchive.entity.User;

@Controller
public class ThumbnailController {
    private static final Log log = LogFactory.getLog(ThumbnailController.class);

    @Autowired
    private Facade facade;

    @Autowired
    private Config config;

//    @Autowired
//    private ImageService imageService;

//    @Autowired
//    @Qualifier("remoteFileService")
//    private FileService fileService;
//
//    @Autowired
//    @Qualifier("remoteImageService")
//    private ImageService imageService;


    @RequestMapping("/thumb")
    public void thumbHandler(
            @RequestParam(required = false) Long id,
            @RequestParam(required = false) String size,
            @RequestParam(required = false) Boolean tmp,
            HttpServletResponse response,
            HttpServletRequest request,
            HttpSession session) throws IOException {
        size = StringUtils.trimToNull(size);
        ThumbSize thumbSize = null;

        if (id == null || size == null || (thumbSize = ThumbSize.findByName(size)) == null) {
            Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

            return;
        }

        tmp = (tmp != null && tmp.booleanValue());

        InputStream inputStream = null;
        try {
            byte[] bytes = facade.getFileService().getThumbnail(id, thumbSize, tmp);
            if (bytes == null || bytes.length == 0) {
                Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

                return;
            }

            long length = bytes.length;
            inputStream = new ByteArrayInputStream(bytes);

            response.setContentType("image/jpeg");
            response.setContentLength((int) length);
            response.setHeader("Content-Disposition", String.format("inline; file=thumb_small_%d.jpg", id));

            OutputStream output = null;
            try {
                output = new BufferedOutputStream(response.getOutputStream());
                IOUtils.copy(inputStream, output);
                output.flush();
            } catch (IOException ex) {
            } finally {
                IOUtils.closeQuietly(output);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(inputStream);
        }

    }

    @RequestMapping("/preview")
    public String previewHandler(
            @RequestParam(required = false) Long id,
            @RequestParam(required = false) Boolean tmp,
            HttpServletResponse response,
            Map<String, Object> model) {
        if (id == null) {
            Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

            return null;
        }

        tmp = (tmp != null ? tmp : false);

        model.put("imageId", id);
        model.put("temporary", tmp);

        return "preview";
    }

    @RequestMapping("/detailed_thumb")
    public String detailedThumbnail(
            @RequestParam(required = true) Long id,
            HttpServletResponse response,
            HttpServletRequest request,
            HttpSession session,
            Map<String, Object> model
    ) {
        User user = SessionUtils.getUser(request, session, facade);
        if (id == null) {
            Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

            return null;
        }

//        Image image = imageService.findById(id);
        Image image = facade.getImageService().findById(id);

        model.put("image", image);
        model.put("imageSize", ThumbSize.MEDIUM.getName());

        return "detailed_thumb";
    }

    @RequestMapping("/preview_img")
    public void previewHandler(
            @RequestParam(required = false) Long id,
            @RequestParam(required = false) Boolean tmp,
            HttpServletResponse response,
            HttpServletRequest request,
            HttpSession session) throws IOException {
//        response.sendRedirect(config.getServerAddress() + "preview_img?" + request.getQueryString());
        if (id == null) {
            Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

            return;
        }

        tmp = tmp != null && tmp;

        InputStream inputStream = null;
        try {
            byte[] bytes = facade.getFileService().getThumbnail(id, ThumbSize.FULL, tmp);
            if (bytes == null || bytes.length == 0) {
                Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);

                return;
            }

            long length = bytes.length;
            inputStream = new ByteArrayInputStream(bytes);


            response.setContentType("image/jpeg");
            response.setContentLength((int) length);
            response.setHeader("Content-Disposition", String.format("inline; file=preview_%d.jpg", id));

            OutputStream output = null;
            try {
                output = new BufferedOutputStream(response.getOutputStream());
                IOUtils.copy(inputStream, output);
                output.flush();
            } catch (Exception ex) {
            } finally {
                IOUtils.closeQuietly(output);
            }
        } finally {
            IOUtils.closeQuietly(inputStream);
        }

    }
}
