/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.command.AddImageUploadCommand;
import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.json.UploadResponse;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.ImageService;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.validator.ChangeImageDataValidator;
import com.imcode.imcms.addon.imagearchive.validator.ImageUploadValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AddImageController {
    private static final Log log = LogFactory.getLog(AddImageController.class);
    @Autowired
    private Facade facade;
    @Autowired
    private ImageService imageService;

    @RequestMapping(value={"/add-image"})
    public ModelAndView indexHandler(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            Utils.redirectToLogin(response, this.facade);
            return null;
        }
        ModelAndView mav = new ModelAndView("add_image");
        HashSet<Category> categories = new HashSet<Category>();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        mav.addObject("upload", (Object)new AddImageUploadCommand());
        mav.addObject("keywords", (Object)this.facade.getKeywordService().getKeywords());
        mav.addObject("categories", categories);
        return mav;
    }

    @RequestMapping(value={"/add-image/multi-upload-form"}, method={RequestMethod.GET})
    public String multiFileDataFromHandler(HttpServletRequest request, HttpServletResponse response, HttpSession session, ModelAndView mav) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            Utils.redirectToLogin(response, this.facade);
            return null;
        }
        mav.addObject("keywords", (Object)this.facade.getKeywordService().getKeywords());
        mav.addObject("categories", (Object)this.facade.getCategoryService().getCategories());
        return "fragments/multi_file_data";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/add-image/upload"})
    @ResponseBody
    public UploadResponse uploadHandler(@ModelAttribute(value="upload") AddImageUploadCommand command, BindingResult result, @ModelAttribute(value="changeData") ChangeImageDataCommand changeData, BindingResult dataResult, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        String contextPath = request.getContextPath();
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            Utils.redirectToLogin(response, this.facade);
            return null;
        }
        ImageUploadValidator validator = new ImageUploadValidator(this.facade);
        ValidationUtils.invokeValidator((Validator)validator, (Object)command.getFile(), (Errors)result);
        if ((command.getFileCount() > 0 || validator.isZipFile()) && changeData.isSubmitted()) {
            ChangeImageDataValidator dataValidator = new ChangeImageDataValidator(this.facade);
            ValidationUtils.invokeValidator((Validator)dataValidator, (Object)changeData, (Errors)dataResult);
        }
        UploadResponse uploadResponse = new UploadResponse();
        if (!result.hasErrors() && !dataResult.hasErrors()) {
            try {
                if (validator.isZipFile()) {
                    List images = this.facade.getImageService().createImagesFromZip(validator.getTempFile());
                    if (changeData.isSubmitted()) {
                        for (Image image : images) {
                            if (image == null) continue;
                            changeData.setImageNm(image.getName());
                            changeData.toImage(image);
                            this.facade.getImageService().updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                        }
                    }
                } else {
                    Image image;
                    if (command.getFileCount() > 1) {
                        image = this.facade.getImageService().createImage(validator.getTempFile(), validator.getImageInfo(), validator.getImageName(), (short)1);
                    } else {
                        image = this.imageService.createImage(validator.getTempFile(), validator.getImageInfo(), validator.getImageName(), (short)1);
                        if (changeData.isSubmitted() && image != null) {
                            changeData.setImageNm(image.getName());
                            changeData.toImage(image);
                            this.imageService.updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                        }
                    }
                    if (image == null) {
                        result.rejectValue("file", "addImage.invalidImageError");
                    } else if (changeData.isSubmitted()) {
                        changeData.setImageNm(image.getName());
                        changeData.toImage(image);
                        this.imageService.updateData(image, changeData.getCategoryIds(), changeData.getImageKeywordNames());
                    }
                }
                if (command.isRedirToSearch()) {
                    uploadResponse.setRedirectOnAllComplete(contextPath + "/archive");
                }
            }
            catch (Exception ex) {
                log.fatal((Object)ex.getMessage(), (Throwable)ex);
                result.rejectValue("file", "addImage.invalidImageError");
            }
            finally {
                this.facade.getFileService().deleteTemporaryFile(validator.getTempFile());
            }
        }
        if (result.hasErrors()) {
            uploadResponse.setImageErrors(this.getErrorsList(result, request.getLocale()));
        }
        if (dataResult.hasErrors()) {
            uploadResponse.setDataErrors(this.getErrorsMap(dataResult, request.getLocale()));
        }
        return uploadResponse;
    }

    private Map<String, String> getErrorsMap(BindingResult result, Locale locale) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (FieldError error : result.getFieldErrors()) {
            errors.put(error.getField(), this.facade.getCommonService().getMessage(error.getCode(), locale, error.getArguments()));
        }
        return errors;
    }

    private List<String> getErrorsList(BindingResult result, Locale locale) {
        return result.getFieldErrors().stream().map(error -> this.facade.getCommonService().getMessage(error.getCode(), locale, error.getArguments())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/add-image/verify-data"})
    public void verifyDataHandler(@ModelAttribute(value="changeData") ChangeImageDataCommand changeData, BindingResult dataResult, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        UploadResponse uploadResponse = new UploadResponse();
        if (changeData.isSubmitted()) {
            ChangeImageDataValidator dataValidator = new ChangeImageDataValidator(this.facade);
            ValidationUtils.invokeValidator((Validator)dataValidator, (Object)changeData, (Errors)dataResult);
        }
        if (dataResult.hasErrors()) {
            uploadResponse.setDataErrors(this.getErrorsMap(dataResult, request.getLocale()));
        }
        Utils.writeJSON(uploadResponse, response);
    }
}

