/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.ConverterUtils;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.EventListener;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ContentWriter
implements EventListener {
    private static final Log log = LogFactory.getLog(ContentWriter.class);
    private String filename;
    protected File file;
    private boolean isInitialized = false;
    private boolean finished = false;
    private PipeLine pipeLine;
    protected boolean headerProcessing = false;
    protected boolean footerProcessing = false;

    public PipeLine getPipeLine() {
        return this.pipeLine;
    }

    public void setPipeLine(PipeLine pipeLine) {
        this.pipeLine = pipeLine;
    }

    public void init() throws Exception {
        this.finished = false;
        this.file = ConverterUtils.getFile(this.filename, false);
        FileUtils.forceMkdir((File)this.file.getParentFile());
        this.isInitialized = true;
    }

    public void shutdown() throws Exception {
        this.finished = true;
        this.isInitialized = false;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void onStartDocument() throws Exception {
    }

    public void onEndDocument() throws Exception {
        this.finished = true;
    }

    public void onDocumentProperties(DocumentMetadata properties) throws Exception {
    }

    public void onStartHeader() throws Exception {
        this.headerProcessing = true;
    }

    public void onEndHeader() throws Exception {
        this.headerProcessing = false;
    }

    public void onStartBlock(String id, TextMetrics metrics, String headlineText) throws Exception {
    }

    public void onEndBlock() throws Exception {
    }

    public void onStartText(String id, TextMetrics metrics) throws Exception {
    }

    public void onEndText() throws Exception {
    }

    public void onStartParagraph(String id, TextMetrics metrics) throws Exception {
    }

    public void onEndParagraph() throws Exception {
    }

    public void onText(TextMetrics metrics, String text, boolean applyMetrics) throws Exception {
    }

    public void onStartFooter() throws Exception {
        this.footerProcessing = true;
    }

    public void onEndFooter() throws Exception {
        this.footerProcessing = false;
    }
}

