/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLWriter
extends ContentWriter {
    private static final Log log = LogFactory.getLog(XMLWriter.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private static final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeFormater = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private Document document = null;
    private Element rootElement = null;
    private Element meta = null;
    private Element content = null;
    private Element header = null;
    private Element footer = null;
    private Element currentBlock = null;
    private Element currentParagraph = null;
    private Element currentText = null;
    private boolean blockStarted = false;
    private boolean paragraphStarted = false;
    private String listId = null;
    private Element currentList = null;

    protected XMLWriter() {
    }

    public XMLWriter(String filename) {
        this.setFilename(filename);
    }

    public void init() throws Exception {
        super.init();
    }

    public void shutdown() throws Exception {
        super.shutdown();
    }

    public void onStartDocument() throws Exception {
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = bf.newDocumentBuilder();
        this.document = db.newDocument();
        Element el = this.document.createElement("imcms");
        this.rootElement = this.document.createElement("document");
        el.appendChild(this.rootElement);
        this.document.appendChild(el);
        this.meta = this.document.createElement("metadata");
        this.rootElement.appendChild(this.meta);
        this.header = this.document.createElement("header");
        this.rootElement.appendChild(this.header);
        this.footer = this.document.createElement("footer");
        this.rootElement.appendChild(this.footer);
        this.content = this.document.createElement("content");
        this.rootElement.appendChild(this.content);
    }

    public void onEndDocument() throws Exception {
        OutputFormat outputFormat = new OutputFormat(this.document);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(2);
        outputFormat.setEncoding("UTF-8");
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
        XMLSerializer serializer = new XMLSerializer((Writer)writer, outputFormat);
        serializer.serialize(this.document);
        ((Writer)writer).close();
    }

    public void onDocumentProperties(DocumentMetadata properties) throws Exception {
        Element created = this.document.createElement("created");
        Element crName = this.document.createElement("name");
        Element crDatetime = this.document.createElement("datetime");
        crName.setTextContent(properties.getCreationAuthor());
        String strDate = properties.getCreationDate() != null ? dateTimeFormater.format(properties.getCreationDate()) : "";
        crDatetime.setTextContent(strDate);
        created.appendChild(crName);
        created.appendChild(crDatetime);
        Element changed = this.document.createElement("changed");
        Element chName = this.document.createElement("name");
        Element chDatetime = this.document.createElement("datetime");
        chName.setTextContent(properties.getChangedAuthor());
        strDate = properties.getChangedDate() != null ? dateTimeFormater.format(properties.getChangedDate()) : "";
        chDatetime.setTextContent(strDate);
        changed.appendChild(chName);
        changed.appendChild(chDatetime);
        Element title = this.document.createElement("title");
        title.setTextContent(properties.getTitle());
        Element keywords = this.document.createElement("keywords");
        keywords.setTextContent(properties.getKeywords());
        Element subject = this.document.createElement("subject");
        subject.setTextContent(properties.getSubject());
        Element comments = this.document.createElement("comments");
        comments.setTextContent(properties.getComments());
        this.meta.appendChild(created);
        this.meta.appendChild(changed);
        this.meta.appendChild(title);
        this.meta.appendChild(keywords);
        this.meta.appendChild(subject);
        this.meta.appendChild(comments);
    }

    public void onStartBlock(String id, TextMetrics metrics, String headlineText) throws Exception {
        this.currentBlock = this.document.createElement("block");
        this.currentBlock.setAttribute("format", metrics.getStyleName());
        Element headline = this.document.createElement("headline");
        headlineText = headlineText.replaceAll("\r$", "");
        Element headlineParagraph = this.document.createElement("p");
        headline.appendChild(headlineParagraph);
        this.addTextWithBreakLines(headlineParagraph, headlineText, metrics, false);
        this.currentBlock.appendChild(headline);
        this.blockStarted = true;
    }

    public void onEndBlock() throws Exception {
        this.content.appendChild(this.currentBlock);
        this.currentBlock = null;
        this.blockStarted = false;
    }

    public void onStartText(String id, TextMetrics metrics) throws Exception {
        this.currentText = this.document.createElement("text");
    }

    public void onEndText() throws Exception {
        if (this.blockStarted) {
            this.currentBlock.appendChild(this.currentText);
        } else {
            Element el = this.headerProcessing ? this.header : (this.footerProcessing ? this.footer : this.content);
            el.appendChild(this.currentText);
        }
        this.currentText = null;
        this.paragraphStarted = false;
    }

    public void onStartParagraph(String id, TextMetrics metrics) throws Exception {
        if (metrics.isNumbering()) {
            if (!metrics.getListId().equals(this.listId)) {
                if (this.currentList != null) {
                    this.currentText.appendChild(this.currentList);
                }
                this.currentList = this.document.createElement("l");
                this.currentList.setAttribute("format", id);
                this.listId = metrics.getListId();
            }
            this.currentParagraph = this.document.createElement("li");
        } else {
            if (this.currentList != null) {
                this.currentText.appendChild(this.currentList);
                this.currentList = null;
                this.listId = null;
            }
            this.currentParagraph = this.document.createElement("p");
        }
        if (this.headerProcessing || this.footerProcessing) {
            this.currentParagraph.setAttribute("format", id);
        }
        this.paragraphStarted = true;
    }

    public void onEndParagraph() throws Exception {
        if (this.currentList != null) {
            this.currentList.appendChild(this.currentParagraph);
        } else {
            this.currentText.appendChild(this.currentParagraph);
        }
        this.currentParagraph = null;
        this.paragraphStarted = false;
    }

    public void onText(TextMetrics metrics, String text, boolean applyMetrics) throws Exception {
        String txt = "" + text;
        txt = txt.replaceAll("[\\u0000-\\u0007]", "");
        txt = txt.replaceAll("\r$", "");
        if (this.paragraphStarted) {
            this.addTextWithBreakLines(this.currentParagraph, txt, metrics, applyMetrics);
        }
    }

    private void addTextWithBreakLines(Element to, String text, TextMetrics metrics, boolean applyMetrics) throws Exception {
        String[] parts = StringUtils.splitPreserveAllTokens((String)text, (String)"\u000b");
        for (int i = 0; i < parts.length; ++i) {
            Node el;
            if (i > 0) {
                to.appendChild(this.document.createElement("br"));
            }
            Text txtEl = this.document.createTextNode(parts[i]);
            Node node = el = applyMetrics ? this.createMetricWrapper(metrics) : null;
            if (el == null) {
                el = txtEl;
            } else {
                el.appendChild(txtEl);
            }
            to.appendChild(el);
        }
    }

    private Node createMetricWrapper(TextMetrics metrics) throws Exception {
        Element node;
        Element wrapper = null;
        if (metrics.isBold()) {
            node = this.document.createElement("strong");
            if (wrapper != null) {
                wrapper.appendChild(node);
            }
            wrapper = node;
        }
        if (metrics.isItalic()) {
            node = this.document.createElement("italic");
            if (wrapper != null) {
                wrapper.appendChild(node);
            }
            wrapper = node;
        }
        if (metrics.isUnderline()) {
            node = this.document.createElement("underline");
            if (wrapper != null) {
                wrapper.appendChild(node);
            }
            wrapper = node;
        }
        return wrapper;
    }
}

