/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.StyleNameResolver;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexStyleNameResolver
extends StyleNameResolver {
    private static final Pattern replPattern = Pattern.compile("^/(.*)/(.*)/$");
    private String[] names = null;
    private HashMap replacements = new HashMap();

    protected RegexStyleNameResolver() {
    }

    public static StyleNameResolver createInstance(String[] names) {
        RegexStyleNameResolver result = new RegexStyleNameResolver();
        if (names != null && names.length > 0) {
            String[] newNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Matcher matcher = replPattern.matcher(name);
                if (matcher.matches()) {
                    int cnt = matcher.groupCount();
                    String sName = matcher.group(1);
                    String sRepl = matcher.group(2);
                    newNames[i] = sName;
                    result.replacements.put(sName, sRepl);
                    continue;
                }
                newNames[i] = name;
            }
            result.names = newNames;
        }
        return result;
    }

    public boolean isKnownStyle(String styleName) {
        if (this.names != null && this.names.length > 0) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!Pattern.matches(this.names[i], styleName)) continue;
                return true;
            }
        }
        return false;
    }

    public String replace(String styleName) {
        if (this.names != null && this.names.length > 0) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (!Pattern.matches(name, styleName)) continue;
                String repl = this.replacements.containsKey(name) ? (String)this.replacements.get(name) : null;
                return repl != null ? styleName.replaceAll(name, repl) : styleName;
            }
        }
        return styleName;
    }
}

