/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.StyleNameResolver;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipeLine {
    private static final Log log = LogFactory.getLog(PipeLine.class);
    private ContentReader reader;
    private Collection writers = new ArrayList();
    private StyleNameResolver docTitleNameResolver;
    private StyleNameResolver blockNameResolver;
    private OpenOfficeConnection connection;
    private String template;
    private boolean searchEnabled = false;
    private String searchFormat = "^${style}.*";

    public ContentReader getReader() {
        return this.reader;
    }

    public void setReader(ContentReader reader) {
        this.reader = reader;
        this.reader.setPipeLine(this);
    }

    public Collection getWriters() {
        return this.writers;
    }

    public synchronized void setWriters(Collection writers) {
        this.writers = writers;
        for (ContentWriter writer : writers) {
            writer.setPipeLine(this);
        }
    }

    public synchronized void addWriter(ContentWriter writer) {
        if (!this.writers.contains(writer)) {
            this.writers.add(writer);
            writer.setPipeLine(this);
        }
    }

    public synchronized void removeWriter(ContentWriter writer) {
        if (this.writers.contains(writer)) {
            this.writers.remove(writer);
        }
    }

    public synchronized void removeAllWriters() {
        this.writers.clear();
    }

    public StyleNameResolver getDocTitleNameResolver() {
        return this.docTitleNameResolver;
    }

    public void setDocTitleNameResolver(StyleNameResolver docTitleNameResolver) {
        this.docTitleNameResolver = docTitleNameResolver;
    }

    public StyleNameResolver getBlockNameResolver() {
        return this.blockNameResolver;
    }

    public void setBlockNameResolver(StyleNameResolver blockNameResolver) {
        this.blockNameResolver = blockNameResolver;
    }

    public OpenOfficeConnection getConnection() {
        return this.connection;
    }

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
    }

    public String getSearchFormat() {
        return this.searchFormat;
    }

    public void setSearchFormat(String searchFormat) {
        this.searchFormat = searchFormat;
    }

    public void init() throws Exception {
        for (ContentWriter writer : this.writers) {
            writer.setPipeLine(this);
            writer.init();
        }
        if (this.reader != null) {
            this.reader.setPipeLine(this);
            this.reader.init();
            this.reader.setEventListeners(this.writers);
        }
    }

    public void execute() throws Exception {
        if (this.connection != null) {
            this.connection.connect();
        }
        if (this.reader != null) {
            this.reader.start();
        }
    }

    public void shutdown() throws Exception {
        for (ContentWriter writer : this.writers) {
            writer.shutdown();
        }
        if (this.reader != null) {
            this.reader.shutdown();
        }
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    public void clear() {
        this.writers.clear();
        this.reader = null;
    }

    public boolean isKnownStyle(String styleName) {
        return this.docTitleNameResolver != null && this.docTitleNameResolver.isKnownStyle(styleName);
    }

    public boolean isKnownBlockStyle(String styleName) {
        return this.blockNameResolver != null && this.blockNameResolver.isKnownStyle(styleName);
    }

    public String replaceKnownStyle(String styleName) {
        return this.docTitleNameResolver != null ? this.docTitleNameResolver.replace(styleName) : styleName;
    }

    public String replaceKnownBlockStyle(String styleName) {
        return this.blockNameResolver != null ? this.blockNameResolver.replace(styleName) : styleName;
    }
}

