/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.PipeOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.ConvertInfo;
import com.imcode.imcms.addon.DocumentConverter.MSWordReader;
import com.imcode.imcms.addon.DocumentConverter.MSWordWriter;
import com.imcode.imcms.addon.DocumentConverter.OOWReader;
import com.imcode.imcms.addon.DocumentConverter.OOWWriter;
import com.imcode.imcms.addon.DocumentConverter.PDFWriter;
import com.imcode.imcms.addon.DocumentConverter.XMLReader;
import com.imcode.imcms.addon.DocumentConverter.XMLWriter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConverterUtils {
    private static final Log log = LogFactory.getLog(ConverterUtils.class);
    public static final String INPUT_PARAM = "i";
    public static final String OUTPUT_PARAM = "o";
    public static final String STYLES_PARAM = "s";
    public static final String BLOCK_STYLES_PARAM = "b";
    public static final String CONNECTION_PARAM = "c";
    public static final String TEMPLATE_PARAM = "t";
    public static final String SEARCH_STYLES_PARAM = "ss";
    public static final String SEARCH_FORMAT_PARAM = "sf";
    public static final String MODE_XML = "x";
    public static final String MODE_MSWORD = "w";
    public static final String MODE_OOWRITER = "o";
    public static final String MODE_PDF = "p";
    public static final String CONN_SOCKET = "socket";
    public static final String CONN_PIPE = "pipe";
    public static final String DEFAULT_SEARCH_FORMAT = "^${style}.*";
    public static final int DEFAULT_OO_PORT = 8100;

    public static Object createPipelineObject(String mode, String type, String filename, OpenOfficeConnection conn) throws IllegalArgumentException {
        return mode.equals(INPUT_PARAM) ? ConverterUtils.createContentReader(new ConvertInfo(filename, type), conn) : ConverterUtils.createContentWriter(new ConvertInfo(filename, type), conn);
    }

    public static OpenOfficeConnection createConnection(String input) {
        PipeOpenOfficeConnection conn = null;
        String[] bits = input.split("[:=]", 2);
        if (bits == null || bits.length != 2) {
            throw new IllegalArgumentException("Can not parse \"" + input + "\" as connection parameters");
        }
        String type = bits[0];
        String[] params = StringUtils.split((String)bits[1], (String)",");
        if (CONN_SOCKET.equals(type)) {
            if (params.length < 2) {
                throw new IllegalArgumentException("Can not parse connection string \"" + input + "\". Socket connection should have the " + "\"socket=host,port\" format.");
            }
            conn = new SocketOpenOfficeConnection(params[0], NumberUtils.toInt((String)params[1], (int)8100));
        } else if (CONN_PIPE.equals(type)) {
            if (params.length < 1) {
                throw new IllegalArgumentException("Can not parse connection string \"" + input + "\". Pipe connection should have the " + "\"pipe=name\" format.");
            }
            conn = new PipeOpenOfficeConnection(params[0]);
        }
        return conn;
    }

    public static File getFile(String filename) {
        return ConverterUtils.getFile(filename, true);
    }

    public static File getFile(String filename, boolean checkExisting) {
        boolean isRelative;
        String prefix = FilenameUtils.getPrefix((String)filename);
        boolean bl = isRelative = prefix == null || prefix.length() == 0;
        if (!isRelative) {
            File file = new File(filename);
            if (!checkExisting || file.exists()) {
                return file;
            }
        } else {
            String curDir = System.getProperty("user.dir");
            String dirSep = System.getProperty("file.separator");
            File file = new File(curDir + dirSep + filename);
            if (!checkExisting || file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static ContentReader createContentReader(ConvertInfo input, OpenOfficeConnection conn) throws IllegalArgumentException {
        if (MODE_XML.equals(input.getType())) {
            return new XMLReader(input.getPath());
        }
        if (MODE_MSWORD.equals(input.getType())) {
            return new MSWordReader(input.getPath());
        }
        if ("o".equals(input.getType())) {
            return new OOWReader(input.getPath(), conn);
        }
        throw new IllegalArgumentException("Unknown type \"" + input.getType() + "\" was detected.");
    }

    public static ContentWriter createContentWriter(ConvertInfo address, OpenOfficeConnection conn) throws IllegalArgumentException {
        if (MODE_XML.equals(address.getType())) {
            return new XMLWriter(address.getPath());
        }
        if (MODE_MSWORD.equals(address.getType())) {
            return new MSWordWriter(address.getPath(), conn);
        }
        if ("o".equals(address.getType())) {
            return new OOWWriter(address.getPath(), conn);
        }
        if (MODE_PDF.equals(address.getType())) {
            return new PDFWriter(address.getPath(), conn);
        }
        throw new IllegalArgumentException("Unknown type \"" + address.getType() + "\" was detected.");
    }

    public static OpenOfficeConnection getConnection(String host, String port) {
        return new SocketOpenOfficeConnection(host, NumberUtils.toInt((String)port, (int)8100));
    }

    public static OpenOfficeConnection getConnection(String host) {
        return new PipeOpenOfficeConnection(host);
    }
}

