/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter.openoffice;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ConverterUtils;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import com.sun.star.awt.FontSlant;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.OutputStreamToXOutputStreamAdapter;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.DateTime;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class TextDocument {
    public static final String URL_CREATE = "private:factory/swriter";
    public static final String URL_STREAM = "private:stream";
    public static final String BLANK_TMPL = "_blank";
    private OpenOfficeConnection conn;
    private XComponentContext context;
    private XComponentLoader loader;
    private XMultiComponentFactory serviceManager;
    private XTextDocument document;
    private XText textContent;
    private XText textHeader;
    private XText textFooter;
    private XTextCursor textCursor;
    private XParagraphCursor paragraphCursor;
    private XTextCursor headerCursor;
    private XParagraphCursor headerParagraphCursor;
    private XTextCursor footerCursor;
    private XParagraphCursor footerParagraphCursor;
    private HashMap styles = new HashMap();
    private XEnumeration paragraphEnum = null;
    private XEnumeration portionEnum = null;
    private XInterface currentParagraph = null;
    private XInterface currentPortion = null;
    private boolean isLoaded = false;

    protected TextDocument() {
    }

    public TextDocument(OpenOfficeConnection conn) {
        this.conn = conn;
    }

    public HashMap getStyles() {
        return this.styles;
    }

    public XText getTextContent() {
        return this.textContent;
    }

    public XText getTextHeader() {
        return this.textHeader;
    }

    public XText getTextFooter() {
        return this.textFooter;
    }

    public XTextCursor getFooterCursor() {
        return this.footerCursor;
    }

    public XParagraphCursor getHeaderParagraphCursor() {
        return this.headerParagraphCursor;
    }

    public XTextCursor getHeaderCursor() {
        return this.headerCursor;
    }

    public XParagraphCursor getParagraphCursor() {
        return this.paragraphCursor;
    }

    public XTextCursor getTextCursor() {
        return this.textCursor;
    }

    public XParagraphCursor getFooterParagraphCursor() {
        return this.footerParagraphCursor;
    }

    public void create() throws Exception {
        this.create(null);
    }

    public void create(String template) throws Exception {
        String url;
        this.context = this.conn.getComponentContext();
        this.loader = this.conn.getDesktop();
        this.serviceManager = this.context.getServiceManager();
        ArrayList<PropertyValue> loadProps = new ArrayList<PropertyValue>();
        loadProps.add(TextDocument.createProperty("Hidden", Boolean.TRUE));
        if (template != null) {
            File templFile = ConverterUtils.getFile(template, true);
            FileInputStream inputStream = new FileInputStream(templFile);
            loadProps.add(TextDocument.createProperty("InputStream", new ByteArrayToXInputStreamAdapter(IOUtils.toByteArray((InputStream)inputStream))));
            url = URL_STREAM;
        } else {
            url = URL_CREATE;
        }
        XComponent cmp = this.loader.loadComponentFromURL(url, BLANK_TMPL, 0, TextDocument.toPropertyArray(loadProps));
        this.document = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)cmp);
        this.isLoaded = true;
        this.collectStyles();
        this.textContent = this.document.getText();
        this.textCursor = this.textContent.createTextCursor();
        this.clearContent(this.textContent);
        this.paragraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.textCursor);
        if (this.textHeader != null) {
            this.headerCursor = this.textHeader.createTextCursor();
            this.clearContent(this.textHeader);
            this.headerParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.headerCursor);
        }
        if (this.textFooter != null) {
            this.footerCursor = this.textFooter.createTextCursor();
            this.clearContent(this.textFooter);
            this.footerParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.footerCursor);
        }
    }

    public void load(File file) throws Exception {
        this.context = this.conn.getComponentContext();
        this.loader = this.conn.getDesktop();
        this.serviceManager = this.context.getServiceManager();
        FileInputStream inputStream = new FileInputStream(file);
        ArrayList<PropertyValue> loadProps = new ArrayList<PropertyValue>();
        loadProps.add(TextDocument.createProperty("Hidden", Boolean.TRUE));
        loadProps.add(TextDocument.createProperty("InputStream", new ByteArrayToXInputStreamAdapter(IOUtils.toByteArray((InputStream)inputStream))));
        XComponent cmp = this.loader.loadComponentFromURL(URL_STREAM, BLANK_TMPL, 0, TextDocument.toPropertyArray(loadProps));
        this.document = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)cmp);
        this.isLoaded = true;
        this.collectStyles();
        this.textContent = this.document.getText();
        this.textCursor = this.textContent.createTextCursor();
        this.paragraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.textCursor);
    }

    protected void clearContent(XText content) {
        ((XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)content)).setString("");
    }

    public void saveAs(File file, String saveFormat) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        XStorable storable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.document);
        FileOutputStream outputStream = new FileOutputStream(file);
        ArrayList<PropertyValue> propList = new ArrayList<PropertyValue>();
        propList.add(TextDocument.createProperty("OutputStream", new OutputStreamToXOutputStreamAdapter((OutputStream)outputStream)));
        if (StringUtils.isNotBlank((String)saveFormat)) {
            propList.add(TextDocument.createProperty("FilterName", saveFormat));
        }
        PropertyValue[] props = TextDocument.toPropertyArray(propList);
        if ("writer_pdf_Export".equals(saveFormat)) {
            storable.storeToURL(URL_STREAM, props);
        } else {
            storable.storeAsURL(URL_STREAM, props);
        }
        ((OutputStream)outputStream).close();
    }

    public void setDocumentMetadata(DocumentMetadata props) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        XDocumentInfoSupplier xdis = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.document);
        XDocumentInfo xdi = xdis.getDocumentInfo();
        XPropertySet xps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xdi);
        xps.setPropertyValue("Author", (Object)props.getCreationAuthor());
        xps.setPropertyValue("CreationDate", (Object)TextDocument.createDateTime(props.getCreationDate()));
        xps.setPropertyValue("ModifiedBy", (Object)props.getChangedAuthor());
        xps.setPropertyValue("ModifyDate", (Object)TextDocument.createDateTime(props.getChangedDate()));
        xps.setPropertyValue("Keywords", (Object)props.getKeywords());
        xps.setPropertyValue("Subject", (Object)props.getSubject());
        xps.setPropertyValue("Title", (Object)props.getTitle());
        xps.setPropertyValue("Description", (Object)props.getComments());
    }

    public DocumentMetadata getDocumentMetadata() throws Exception {
        DocumentMetadata props = new DocumentMetadata();
        if (!this.isLoaded) {
            return props;
        }
        XDocumentInfoSupplier xdis = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.document);
        XDocumentInfo xdi = xdis.getDocumentInfo();
        XPropertySet xps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xdi);
        props.setCreationAuthor((String)xps.getPropertyValue("Author"));
        props.setCreationDate(TextDocument.createDate((DateTime)xps.getPropertyValue("CreationDate")));
        props.setChangedAuthor((String)xps.getPropertyValue("ModifiedBy"));
        props.setChangedDate(TextDocument.createDate((DateTime)xps.getPropertyValue("ModifyDate")));
        props.setKeywords((String)xps.getPropertyValue("Keywords"));
        props.setSubject((String)xps.getPropertyValue("Subject"));
        props.setTitle((String)xps.getPropertyValue("Title"));
        props.setComments((String)xps.getPropertyValue("Description"));
        return props;
    }

    public void close() throws Exception {
        if (!this.isLoaded) {
            return;
        }
        XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.document);
        if (closeable != null) {
            try {
                closeable.close(true);
            }
            catch (CloseVetoException closeVetoException) {}
        } else {
            this.document.dispose();
        }
        this.isLoaded = false;
    }

    public void createParagraph(XTextCursor xTextCursor, XParagraphCursor xParagraphCursor, XText xText) throws Exception {
        if (null == xText || null == xParagraphCursor || null == xTextCursor) {
            return;
        }
        xTextCursor.gotoEnd(false);
        xParagraphCursor.gotoEnd(false);
        xText.insertControlCharacter((XTextRange)xParagraphCursor, (short)0, false);
    }

    public void insertText(XText xText, XParagraphCursor xParagraphCursor, String text, TextMetrics metrics) throws Exception {
        if (null == xText || null == xParagraphCursor) {
            return;
        }
        String[] parts = StringUtils.splitPreserveAllTokens((String)text, (String)"\u000b");
        for (int i = 0; i < parts.length; ++i) {
            xParagraphCursor.collapseToEnd();
            if (i > 0) {
                xText.insertControlCharacter((XTextRange)xParagraphCursor, (short)1, false);
            }
            xText.insertString((XTextRange)xParagraphCursor, parts[i], true);
            this.applyTextStyle(xParagraphCursor, metrics);
            xParagraphCursor.collapseToEnd();
        }
    }

    public void insertFile(File file) throws Exception {
        if (null == this.textCursor) {
            return;
        }
        this.textCursor.gotoEnd(false);
        XDocumentInsertable documentInsertable = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)this.textCursor);
        String fileUrl = "file:///" + file.getAbsolutePath().replace("\\", "/");
        documentInsertable.insertDocumentFromURL(fileUrl, null);
    }

    public void applyParagraphStyle(XParagraphCursor xParagraphCursor, TextMetrics metrics) throws Exception {
        if (metrics == null) {
            return;
        }
        String styleName = metrics.getStyleName();
        if (StringUtils.isNotBlank((String)styleName) && this.styles.containsKey(styleName)) {
            xParagraphCursor.collapseToStart();
            xParagraphCursor.gotoEndOfParagraph(true);
            XPropertySet paragraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xParagraphCursor);
            paragraphPropertySet.setPropertyValue("ParaStyleName", (Object)styleName);
            xParagraphCursor.gotoEndOfParagraph(true);
        }
    }

    public void applyTextStyle(XParagraphCursor xParagraphCursor, TextMetrics metrics) throws Exception {
        if (metrics == null) {
            return;
        }
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xParagraphCursor);
        Float weight = Float.valueOf(metrics.isBold() ? 150.0f : 100.0f);
        short underline = metrics.isUnderline() ? (short)1 : 0;
        FontSlant posture = metrics.isItalic() ? FontSlant.ITALIC : FontSlant.NONE;
        propertySet.setPropertyValue("CharWeight", (Object)weight);
        propertySet.setPropertyValue("CharUnderline", (Object)underline);
        propertySet.setPropertyValue("CharPosture", (Object)posture);
    }

    public void startParagraphEnumeration(XText text) throws Exception {
        XEnumerationAccess paragraphEnumAcc = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)text);
        this.paragraphEnum = paragraphEnumAcc.createEnumeration();
    }

    public boolean nextParagraph() throws Exception {
        if (this.paragraphEnum == null || this.paragraphEnum.hasMoreElements()) {
            this.currentParagraph = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)this.paragraphEnum.nextElement());
            return true;
        }
        return false;
    }

    public String getParagraphText() throws Exception {
        if (this.paragraphEnum == null || this.currentParagraph == null) {
            return null;
        }
        XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.currentParagraph);
        if (textRange == null) {
            return "";
        }
        String text = textRange.getString();
        return text;
    }

    public TextMetrics getParagraphStyle() throws Exception {
        if (this.paragraphEnum == null || this.currentParagraph == null) {
            return null;
        }
        XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.currentParagraph);
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textRange);
        return TextDocument.createTextMetrics(propertySet);
    }

    public void startPortionEnumeration() throws Exception {
        XEnumerationAccess portionEnumAcc = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)this.currentParagraph);
        this.portionEnum = portionEnumAcc.createEnumeration();
    }

    public boolean nextPortion() throws Exception {
        if (this.portionEnum == null || this.portionEnum.hasMoreElements()) {
            this.currentPortion = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)this.portionEnum.nextElement());
            return true;
        }
        return false;
    }

    public String getPortionText() throws Exception {
        if (this.portionEnum == null || this.currentPortion == null) {
            return null;
        }
        XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.currentPortion);
        String text = textRange.getString();
        return text;
    }

    public TextMetrics getPortionStyle() throws Exception {
        if (this.portionEnum == null || this.currentPortion == null) {
            return null;
        }
        XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.currentPortion);
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textRange);
        return TextDocument.createTextMetrics(propertySet);
    }

    private void collectStyles() throws Exception {
        if (!this.isLoaded) {
            return;
        }
        this.styles.clear();
        XStyleFamiliesSupplier styleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.document);
        XNameAccess families = styleFamiliesSupplier.getStyleFamilies();
        XNameAccess pageStyles = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)families.getByName("PageStyles"));
        XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)pageStyles.getByName("Standard"));
        XPropertySet xStyleProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStyle);
        Object headerObj = xStyleProps.getPropertyValue("HeaderText");
        Object footerObj = xStyleProps.getPropertyValue("FooterText");
        this.textHeader = (XText)((Any)headerObj).getObject();
        this.textFooter = (XText)((Any)footerObj).getObject();
        XIndexAccess styleCollection = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)families.getByName("ParagraphStyles"));
        if (styleCollection != null) {
            int count = styleCollection.getCount();
            for (int i = 0; i < count; ++i) {
                XStyle style = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)styleCollection.getByIndex(i));
                String name = style.getName();
                boolean isInUse = style.isInUse();
                boolean isUserDefined = style.isUserDefined();
                this.styles.put(name, style);
            }
        }
    }

    private static PropertyValue createProperty(String name, Object value) {
        PropertyValue prop = new PropertyValue();
        prop.Name = name;
        prop.Value = value;
        return prop;
    }

    private static PropertyValue[] toPropertyArray(List propList) {
        PropertyValue[] props = new PropertyValue[propList.size()];
        propList.toArray(props);
        return props;
    }

    private static DateTime createDateTime(Date date) {
        DateTime dt = new DateTime();
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            dt.Year = (short)cal.get(1);
            dt.Month = (short)cal.get(2);
            dt.Day = (short)cal.get(5);
            dt.Hours = (short)cal.get(11);
            dt.Minutes = (short)cal.get(12);
            dt.Seconds = (short)cal.get(13);
        }
        return dt;
    }

    private static Date createDate(DateTime dt) {
        Date date = null;
        if (dt != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, dt.Year);
            cal.set(2, dt.Month);
            cal.set(5, dt.Day);
            cal.set(11, dt.Hours);
            cal.set(12, dt.Minutes);
            cal.set(13, dt.Seconds);
            date = cal.getTime();
        }
        return date;
    }

    private static TextMetrics createTextMetrics(XPropertySet propertySet) throws Exception {
        TextMetrics metrics = new TextMetrics();
        if (propertySet != null) {
            metrics.setStyleName((String)propertySet.getPropertyValue("ParaStyleName"));
            Float weight = (Float)propertySet.getPropertyValue("CharWeight");
            Short underline = (Short)propertySet.getPropertyValue("CharUnderline");
            FontSlant posture = (FontSlant)propertySet.getPropertyValue("CharPosture");
            metrics.setBold(weight.equals(Float.valueOf(150.0f)));
            metrics.setUnderline(underline != 0);
            metrics.setItalic(posture.equals(FontSlant.ITALIC));
        }
        return metrics;
    }
}

