/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.EventListener;
import com.imcode.imcms.addon.DocumentConverter.MultiDocsWriter;
import com.imcode.imcms.addon.DocumentConverter.OOWWriter;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLReader
extends ContentReader {
    private static final Log log = LogFactory.getLog(XMLReader.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private static final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeFormater = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private Document document = null;
    private Element rootElement = null;
    private Element meta = null;
    private Element content = null;
    private Element header = null;
    private Element footer = null;

    protected XMLReader() {
    }

    public XMLReader(String filename) {
        this.setFilename(filename);
    }

    public void init() throws Exception {
        super.init();
    }

    public void start() throws Exception {
        super.start();
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = bf.newDocumentBuilder();
        this.document = db.parse(this.getFile());
        NodeList list = this.document.getDocumentElement().getElementsByTagName("document");
        if (list.getLength() > 1) {
            Collection<EventListener> listeners = this.getEventListeners();
            ArrayList<EventListener> multiListeners = new ArrayList<EventListener>();
            for (EventListener l : listeners) {
                OOWWriter w = (OOWWriter)l;
                MultiDocsWriter mw = new MultiDocsWriter(list.getLength(), w.file.getAbsolutePath(), w.getConnection(), w.getSaveFormat());
                mw.init();
                mw.setPipeLine(this.getPipeLine());
                multiListeners.add(mw);
            }
            this.setEventListeners(multiListeners);
        }
        for (int i = 0; i < list.getLength(); ++i) {
            this.rootElement = (Element)list.item(i);
            this.meta = this.getFirstElementByName(this.rootElement, "metadata");
            this.content = this.getFirstElementByName(this.rootElement, "content");
            this.header = this.getFirstElementByName(this.rootElement, "header");
            this.footer = this.getFirstElementByName(this.rootElement, "footer");
            this.startDocument();
            this.processMetadata();
            this.processHeader();
            this.processFooter();
            this.processContent();
            this.endDocument();
        }
    }

    public void shutdown() throws Exception {
        super.shutdown();
    }

    private void processMetadata() throws Exception {
        DocumentMetadata metadata = new DocumentMetadata();
        if (this.meta != null) {
            Element changed;
            Element created = this.getFirstElementByName(this.meta, "created");
            if (created != null) {
                Element name = this.getFirstElementByName(created, "name");
                Element date = this.getFirstElementByName(created, "datetime");
                metadata.setCreationAuthor(this.getNodeTextContent(name));
                metadata.setCreationDate(this.getNodeDatetimeContent(date));
            }
            if ((changed = this.getFirstElementByName(this.meta, "changed")) != null) {
                Element name = this.getFirstElementByName(changed, "name");
                Element date = this.getFirstElementByName(changed, "datetime");
                metadata.setChangedAuthor(this.getNodeTextContent(name));
                metadata.setChangedDate(this.getNodeDatetimeContent(date));
            }
            Element title = this.getFirstElementByName(this.meta, "title");
            metadata.setTitle(this.getNodeTextContent(title));
            Element keywords = this.getFirstElementByName(this.meta, "keywords");
            metadata.setKeywords(this.getNodeTextContent(keywords));
            Element subject = this.getFirstElementByName(this.meta, "subject");
            metadata.setSubject(this.getNodeTextContent(subject));
            Element comments = this.getFirstElementByName(this.meta, "comments");
            metadata.setComments(this.getNodeTextContent(comments));
        }
        this.documentProperties(metadata);
    }

    private void processHeader() throws Exception {
        if (this.header == null) {
            return;
        }
        this.startHeader();
        NodeList list = this.header.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if (!"text".equals(nodeName)) continue;
            this.processTextTag(el);
        }
        this.endHeader();
    }

    private void processFooter() throws Exception {
        if (this.footer == null) {
            return;
        }
        this.startFooter();
        NodeList list = this.footer.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if (!"text".equals(nodeName)) continue;
            this.processTextTag(el);
        }
        this.endFooter();
    }

    private void processContent() throws Exception {
        if (this.content == null) {
            return;
        }
        NodeList list = this.content.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if ("text".equals(nodeName)) {
                this.processTextTag(el);
                continue;
            }
            if (!"block".equals(nodeName)) continue;
            this.processBlockTag(el);
        }
    }

    private void processTextTag(Element el) throws Exception {
        String format = el.getAttribute("format");
        TextMetrics metrics = new TextMetrics();
        if (StringUtils.isNotBlank((String)format)) {
            metrics.setStyleName(format);
        }
        this.startText(format, metrics);
        NodeList pList = el.getElementsByTagName("p");
        int pCount = pList.getLength();
        for (int i = 0; i < pCount; ++i) {
            this.processParagraphTag((Element)pList.item(i));
        }
        this.endText();
    }

    private void processParagraphTag(Element paragraphTag) throws Exception {
        String format = paragraphTag.getAttribute("format");
        TextMetrics metrics = new TextMetrics();
        if (StringUtils.isNotBlank((String)format)) {
            metrics.setStyleName(format);
        }
        this.startParagraph(format, metrics);
        NodeList list = paragraphTag.getChildNodes();
        int count = list.getLength();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                Node txtNode = list.item(i);
                TextMetrics txtMetrics = new TextMetrics();
                StringBuffer text = new StringBuffer();
                if ("br".equalsIgnoreCase(txtNode.getNodeName())) {
                    this.text(txtMetrics, "\u000b", true);
                    continue;
                }
                this.getFormattedText(txtNode, txtMetrics, text);
                String str = text.toString().replace("\n", "");
                this.text(txtMetrics, str, true);
            }
        } else {
            String text = this.getNodeTextContent(paragraphTag);
            this.text(metrics, text, true);
        }
        this.endParagraph();
    }

    private void processBlockTag(Element el) throws Exception {
        String format = el.getAttribute("format");
        Element head = this.getFirstElementByName(el, "headline");
        Element headParagraph = this.getFirstElementByName(head, "p");
        String headline = this.getNodeTextContent(headParagraph);
        TextMetrics metrics = null;
        if (StringUtils.isNotBlank((String)format)) {
            metrics = new TextMetrics();
            metrics.setStyleName(format);
        }
        this.startBlock(format, metrics, headline);
        NodeList textNodes = el.getElementsByTagName("text");
        if (textNodes.getLength() > 0) {
            this.processTextTag((Element)textNodes.item(0));
        }
        this.endBlock();
    }

    private Element getFirstElementByName(Element node, String name) {
        if (node == null) {
            return null;
        }
        NodeList list = node.getElementsByTagName(name);
        Element el = null;
        int cnt = list.getLength();
        if (cnt != 0) {
            el = (Element)list.item(0);
        }
        return el;
    }

    private String getNodeTextContent(Element el) {
        return el != null ? el.getTextContent() : null;
    }

    private Date getNodeDatetimeContent(Element el) throws ParseException {
        if (el == null) {
            return null;
        }
        String str = el.getTextContent();
        return dateTimeFormater.parse(str);
    }

    private boolean getFormattedText(Node node, TextMetrics metrics, StringBuffer buf) {
        if (node == null) {
            return false;
        }
        short type = node.getNodeType();
        String name = node.getNodeName();
        if (type == 3) {
            buf.append(node.getTextContent());
            return true;
        }
        if (type == 1) {
            if ("strong".equals(name)) {
                metrics.setBold(true);
            } else if ("italic".equals(name)) {
                metrics.setItalic(true);
            } else if ("underline".equals(name)) {
                metrics.setUnderline(true);
            }
        }
        NodeList list = node.getChildNodes();
        int cnt = list.getLength();
        for (int i = 0; i < cnt; ++i) {
            boolean result = this.getFormattedText(list.item(i), metrics, buf);
            if (!result) continue;
            return true;
        }
        return false;
    }
}

