/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.OOWWriter;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import com.imcode.imcms.addon.DocumentConverter.openoffice.TextDocument;
import java.io.File;
import java.util.UUID;

public class MultiDocsWriter
extends ContentWriter {
    private OOWWriter[] writers;
    private int writerIndex = 0;
    private OpenOfficeConnection connection;
    private String outputFormat;

    public MultiDocsWriter(int documentsNumber, String filename, OpenOfficeConnection connection, String outputFormat) throws Exception {
        this.writers = new OOWWriter[documentsNumber];
        String directory = new File(filename).getParent();
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i] = new OOWWriter(directory + "/" + UUID.randomUUID().toString() + ".odt", connection);
            this.writers[i].init();
        }
        this.connection = connection;
        this.outputFormat = outputFormat;
        this.setFilename(filename);
    }

    public void setPipeLine(PipeLine pipeLine) {
        super.setPipeLine(pipeLine);
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setPipeLine(pipeLine);
        }
    }

    public void onStartDocument() throws Exception {
        this.writers[this.writerIndex].onStartDocument();
    }

    public void onEndDocument() throws Exception {
        this.writers[this.writerIndex].onEndDocument();
        ++this.writerIndex;
        if (this.writerIndex >= this.writers.length) {
            TextDocument td = new TextDocument(this.connection);
            td.load(this.writers[0].file);
            for (int i = 1; i < this.writers.length; ++i) {
                td.insertFile(this.writers[i].file);
            }
            td.saveAs(this.file, this.outputFormat);
        }
    }

    public void onDocumentProperties(DocumentMetadata properties) throws Exception {
        this.writers[this.writerIndex].onDocumentProperties(properties);
    }

    public void onStartHeader() throws Exception {
        this.writers[this.writerIndex].onStartHeader();
    }

    public void onEndHeader() throws Exception {
        this.writers[this.writerIndex].onEndHeader();
    }

    public void onStartBlock(String id, TextMetrics metrics, String headlineText) throws Exception {
        this.writers[this.writerIndex].onStartBlock(id, metrics, headlineText);
    }

    public void onEndBlock() throws Exception {
        this.writers[this.writerIndex].onEndBlock();
    }

    public void onStartText(String id, TextMetrics metrics) throws Exception {
        this.writers[this.writerIndex].onStartText(id, metrics);
    }

    public void onEndText() throws Exception {
        this.writers[this.writerIndex].onEndText();
    }

    public void onStartParagraph(String id, TextMetrics metrics) throws Exception {
        this.writers[this.writerIndex].onStartParagraph(id, metrics);
    }

    public void onEndParagraph() throws Exception {
        this.writers[this.writerIndex].onEndParagraph();
    }

    public void onText(TextMetrics metrics, String text, boolean applyMetrics) throws Exception {
        this.writers[this.writerIndex].onText(metrics, text, applyMetrics);
    }

    public void onStartFooter() throws Exception {
        this.writers[this.writerIndex].onStartFooter();
    }

    public void onEndFooter() throws Exception {
        this.writers[this.writerIndex].onEndFooter();
    }
}

