/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.ConverterUtils;
import com.imcode.imcms.addon.DocumentConverter.ListStyleNameResolver;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.RegexStyleNameResolver;
import com.imcode.imcms.addon.DocumentConverter.StyleNameResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConverterApplication {
    private static final Log log = LogFactory.getLog(ConverterApplication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean showHelp;
        Options options = new Options();
        Option helpOpt = new Option("h", "help", false, "Print this message");
        Option inputOpt = new Option("i", "input", true, "Use filename for given type.");
        inputOpt.setArgName("type=filename");
        inputOpt.setRequired(true);
        Option outputOpt = new Option("o", "output", true, "Use filename for given type.");
        outputOpt.setArgName("type=filename[,type2=filename2[, ...]]");
        outputOpt.setRequired(true);
        Option stylesOpt = new Option("s", "styles", true, "Document title styles.");
        stylesOpt.setArgName("styleType=<style arguments>");
        stylesOpt.setRequired(false);
        Option blockStylesOpt = new Option("b", "blockstyles", true, "Block styles.");
        blockStylesOpt.setArgName("styleType=<style arguments>");
        blockStylesOpt.setRequired(false);
        Option connOpt = new Option("c", "connection", true, "Parameters of OpenOffice connection.");
        connOpt.setArgName("type=params");
        connOpt.setRequired(false);
        Option templOpt = new Option("t", "template", true, "The OpenOffice template file.");
        templOpt.setArgName("filename");
        templOpt.setRequired(false);
        Option searchOpt = new Option("ss", "search-styles", false, "Enables searching suitable style in template.");
        searchOpt.setRequired(false);
        Option searchFormatOpt = new Option("sf", "search-format", true, "Specifies search style format using RegExp.");
        searchFormatOpt.setRequired(false);
        options.addOption(helpOpt);
        options.addOption(inputOpt);
        options.addOption(outputOpt);
        options.addOption(stylesOpt);
        options.addOption(blockStylesOpt);
        options.addOption(connOpt);
        options.addOption(templOpt);
        options.addOption(searchOpt);
        options.addOption(searchFormatOpt);
        CommandLine cmdLine = null;
        PipeLine pipeLine = null;
        try {
            StyleNameResolver resolver;
            String stylesString;
            BasicParser parser = new BasicParser();
            cmdLine = parser.parse(options, args);
            String inputString = cmdLine.getOptionValue("i");
            String outputString = cmdLine.getOptionValue("o");
            OpenOfficeConnection conn = null;
            if (cmdLine.hasOption("c")) {
                conn = ConverterUtils.createConnection(cmdLine.getOptionValue("c"));
            }
            pipeLine = ConverterApplication.buildPipeline(inputString, outputString, conn);
            if (cmdLine.hasOption("s")) {
                stylesString = cmdLine.getOptionValue("s");
                resolver = ConverterApplication.createNameResolver(stylesString);
                pipeLine.setDocTitleNameResolver(resolver);
            }
            if (cmdLine.hasOption("b")) {
                stylesString = cmdLine.getOptionValue("b");
                resolver = ConverterApplication.createNameResolver(stylesString);
                pipeLine.setBlockNameResolver(resolver);
            }
            if (cmdLine.hasOption("t")) {
                String templName = cmdLine.getOptionValue("t");
                pipeLine.setTemplate(templName);
            }
            if (cmdLine.hasOption("ss")) {
                pipeLine.setSearchEnabled(true);
            }
            if (cmdLine.hasOption("sf")) {
                String searchFormat = cmdLine.getOptionValue("sf");
                pipeLine.setSearchFormat(searchFormat);
            }
            pipeLine.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pipeLine != null) {
                try {
                    pipeLine.shutdown();
                }
                catch (Exception e) {}
                pipeLine.clear();
            }
        }
        boolean bl = showHelp = cmdLine == null || cmdLine.hasOption("h") || cmdLine.getOptions() == null || cmdLine.getOptions().length == 0;
        if (showHelp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(100);
            formatter.printHelp(" ", "", options, "Types: x (XML), w (MS Word), o (OpenOffice)");
        }
    }

    private static PipeLine buildPipeline(String input, String output, OpenOfficeConnection conn) throws Exception {
        Collection inputs = ConverterApplication.processInput("i", input, conn);
        Collection outputs = ConverterApplication.processInput("o", output, conn);
        PipeLine pipeLine = new PipeLine();
        pipeLine.setConnection(conn);
        if (inputs.size() != 1) {
            throw new IllegalArgumentException("Can not create more than one input reader.");
        }
        pipeLine.setReader((ContentReader)inputs.iterator().next());
        for (ContentWriter writer : outputs) {
            pipeLine.addWriter(writer);
        }
        pipeLine.init();
        return pipeLine;
    }

    private static Collection processInput(String mode, String input, OpenOfficeConnection conn) throws IllegalArgumentException {
        ArrayList<Object> result = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(input, ",;");
        while (tokenizer.hasMoreTokens()) {
            String part = tokenizer.nextToken();
            String[] bits = part.split("[:=]", 2);
            if (bits == null || bits.length != 2) {
                throw new IllegalArgumentException("Can not parse \"" + part + "\" as input or output file");
            }
            String type = bits[0];
            String filename = bits[1];
            Object obj = ConverterUtils.createPipelineObject(mode, type, filename, conn);
            result.add(obj);
        }
        return result;
    }

    private static StyleNameResolver createNameResolver(String param) throws IllegalArgumentException {
        StyleNameResolver result = null;
        String[] bits = param.split("[:=]", 2);
        if (bits == null || bits.length != 2) {
            throw new IllegalArgumentException("Can not parse \"" + param + "\" as style name resolver");
        }
        String type = bits[0];
        String styles = bits[1];
        if ("r".equals(type)) {
            String[] names = StringUtils.split((String)styles, (String)";");
            result = RegexStyleNameResolver.createInstance(names);
        } else if ("l".equals(type)) {
            String[] names = StringUtils.split((String)styles, (String)",;");
            result = ListStyleNameResolver.createInstance(names);
        }
        return result;
    }
}

