/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import com.imcode.imcms.addon.DocumentConverter.openoffice.TextDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OOWReader
extends ContentReader {
    private static final Log log = LogFactory.getLog(OOWReader.class);
    private OpenOfficeConnection connection;
    private TextDocument textDocument = null;

    protected OOWReader() {
    }

    public OOWReader(String filename, OpenOfficeConnection connection) {
        this.setFilename(filename);
        this.connection = connection;
    }

    public void init() throws Exception {
        super.init();
    }

    public void shutdown() throws Exception {
        super.shutdown();
    }

    public void start() throws Exception {
        super.start();
        this.textDocument = new TextDocument(this.connection);
        this.textDocument.load(this.getFile());
        this.startDocument();
        DocumentMetadata meta = this.textDocument.getDocumentMetadata();
        this.documentProperties(meta);
        this.processHeader();
        this.processFooter();
        this.processContent();
        this.textDocument.close();
        this.endDocument();
    }

    private void processHeader() throws Exception {
        if (this.textDocument.getTextHeader() == null) {
            return;
        }
        this.startHeader();
        PipeLine pipeLine = this.getPipeLine();
        this.textDocument.startParagraphEnumeration(this.textDocument.getTextHeader());
        boolean isTextStarted = false;
        while (this.textDocument.nextParagraph()) {
            this.textDocument.getParagraphText();
            TextMetrics metrics = this.textDocument.getParagraphStyle();
            String styleName = metrics.getStyleName();
            styleName = pipeLine.replaceKnownBlockStyle(styleName);
            metrics.setStyleName(styleName);
            if (!isTextStarted) {
                this.startText(styleName, metrics);
                isTextStarted = true;
            }
            this.startParagraph(styleName, metrics);
            this.textDocument.startPortionEnumeration();
            while (this.textDocument.nextPortion()) {
                String text = this.textDocument.getPortionText();
                TextMetrics pMetrics = this.textDocument.getPortionStyle();
                this.text(pMetrics, text, true);
            }
            this.endParagraph();
        }
        this.endText();
        this.endHeader();
    }

    private void processFooter() throws Exception {
        if (this.textDocument.getTextFooter() == null) {
            return;
        }
        this.startFooter();
        PipeLine pipeLine = this.getPipeLine();
        this.textDocument.startParagraphEnumeration(this.textDocument.getTextFooter());
        boolean isTextStarted = false;
        while (this.textDocument.nextParagraph()) {
            this.textDocument.getParagraphText();
            TextMetrics metrics = this.textDocument.getParagraphStyle();
            String styleName = metrics.getStyleName();
            styleName = pipeLine.replaceKnownBlockStyle(styleName);
            metrics.setStyleName(styleName);
            if (!isTextStarted) {
                this.startText(styleName, metrics);
                isTextStarted = true;
            }
            this.startParagraph(styleName, metrics);
            this.textDocument.startPortionEnumeration();
            while (this.textDocument.nextPortion()) {
                String text = this.textDocument.getPortionText();
                TextMetrics pMetrics = this.textDocument.getPortionStyle();
                this.text(pMetrics, text, true);
            }
            this.endParagraph();
        }
        this.endText();
        this.endFooter();
    }

    private void processContent() throws Exception {
        PipeLine pipeLine = this.getPipeLine();
        this.textDocument.startParagraphEnumeration(this.textDocument.getTextContent());
        boolean blockStarted = false;
        boolean textStarted = false;
        while (this.textDocument.nextParagraph()) {
            String paraText = this.textDocument.getParagraphText();
            TextMetrics metrics = this.textDocument.getParagraphStyle();
            String styleName = metrics.getStyleName();
            if (styleName == null) {
                if (blockStarted) {
                    if (textStarted) {
                        this.endText();
                        textStarted = false;
                    }
                    this.endBlock();
                    blockStarted = false;
                    continue;
                }
                if (!textStarted) continue;
                this.endText();
                textStarted = false;
                continue;
            }
            boolean isBlockStyle = pipeLine.isKnownBlockStyle(styleName);
            boolean isDocTitleStyle = pipeLine.isKnownStyle(styleName);
            if (isBlockStyle) {
                styleName = pipeLine.replaceKnownBlockStyle(styleName);
                metrics.setStyleName(styleName);
                if (blockStarted) {
                    if (textStarted) {
                        this.endText();
                        textStarted = false;
                    }
                    this.endBlock();
                } else if (textStarted) {
                    this.endText();
                    textStarted = false;
                }
                this.startBlock(styleName, metrics, paraText);
                blockStarted = true;
                continue;
            }
            if (!textStarted) {
                this.startText(styleName, metrics);
                textStarted = true;
            }
            this.startParagraph(styleName, metrics);
            this.textDocument.startPortionEnumeration();
            while (this.textDocument.nextPortion()) {
                String text = this.textDocument.getPortionText();
                TextMetrics pMetrics = this.textDocument.getPortionStyle();
                this.text(pMetrics, text, !isDocTitleStyle);
            }
            this.endParagraph();
        }
        if (blockStarted) {
            if (textStarted) {
                this.endText();
            }
            this.endBlock();
            blockStarted = false;
        }
    }
}

