/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.ContentReader;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;

public class MSWordReader
extends ContentReader {
    private static final Log log = LogFactory.getLog(MSWordReader.class);
    private InputStream stream = null;
    private HWPFDocument document = null;

    protected MSWordReader() {
    }

    public MSWordReader(String filename) {
        this.setFilename(filename);
    }

    public void init() throws Exception {
        super.init();
    }

    public void start() throws Exception {
        super.start();
        this.stream = new FileInputStream(this.getFile());
        this.document = new HWPFDocument(this.stream);
        this.startDocument();
        SummaryInformation info = this.document.getSummaryInformation();
        DocumentMetadata props = this.processProperties(info);
        this.documentProperties(props);
        this.processContent();
        this.endDocument();
    }

    public void shutdown() throws Exception {
        super.shutdown();
        this.document = null;
        IOUtils.closeQuietly((InputStream)this.stream);
        this.stream = null;
    }

    private DocumentMetadata processProperties(SummaryInformation info) {
        DocumentMetadata result = new DocumentMetadata();
        result.setCreationAuthor(info.getAuthor());
        result.setCreationDate(info.getCreateDateTime());
        result.setChangedAuthor(info.getLastAuthor());
        result.setChangedDate(info.getLastSaveDateTime());
        result.setTitle(info.getTitle());
        result.setKeywords(info.getKeywords());
        result.setSubject(info.getSubject());
        result.setComments(info.getComments());
        return result;
    }

    private void processContent() throws Exception {
        Range range = this.document.getRange();
        int numParagraphs = range.numParagraphs();
        StyleSheet styleSheet = this.document.getStyleSheet();
        if (numParagraphs > 0) {
            boolean blockStarted = false;
            boolean textStarted = false;
            for (int i = 0; i < numParagraphs; ++i) {
                Paragraph para = range.getParagraph(i);
                short styleIdx = para.getStyleIndex();
                StyleDescription desc = styleSheet.getStyleDescription((int)styleIdx);
                String styleName = desc.getName();
                TextMetrics metrics = new TextMetrics();
                metrics.setStyleName(styleName);
                String paraText = para.text();
                boolean isBlock = this.isBlockStyle(desc);
                if (isBlock) {
                    styleName = this.getPipeLine().replaceKnownBlockStyle(styleName);
                    metrics.setStyleName(styleName);
                    if (blockStarted) {
                        if (textStarted) {
                            this.endText();
                            textStarted = false;
                        }
                        this.endBlock();
                    } else if (textStarted) {
                        this.endText();
                        textStarted = false;
                    }
                    this.startBlock(styleName, metrics, paraText);
                    blockStarted = true;
                } else {
                    if (!textStarted) {
                        this.startText(styleName, metrics);
                        textStarted = true;
                    }
                    this.startParagraph(styleName, metrics);
                    int paraCharacterRuns = para.numCharacterRuns();
                    if (paraCharacterRuns > 1) {
                        for (int j = 0; j < paraCharacterRuns; ++j) {
                            CharacterRun chRun = para.getCharacterRun(j);
                            String crText = chRun.text();
                            metrics.setBold(chRun.isBold());
                            metrics.setItalic(chRun.isItalic());
                            int undCode = chRun.getUnderlineCode();
                            metrics.setUnderline(undCode != 0);
                            this.text(metrics, crText, true);
                        }
                    } else {
                        this.text(metrics, paraText, true);
                    }
                    this.endParagraph();
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)paraText);
            }
            if (textStarted) {
                this.endText();
            }
            if (blockStarted) {
                this.endBlock();
            }
        }
    }

    private boolean isBlockStyle(StyleDescription desc) {
        String styleName = desc.getName();
        PipeLine pipeLine = this.getPipeLine();
        return pipeLine != null && pipeLine.isKnownBlockStyle(styleName);
    }
}

