/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ContentWriter;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import com.imcode.imcms.addon.DocumentConverter.openoffice.TextDocument;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OOWWriter
extends ContentWriter {
    private static final Log log = LogFactory.getLog(OOWWriter.class);
    private OpenOfficeConnection connection;
    private TextDocument textDocument = null;
    private String saveFormat = "";

    protected OOWWriter() {
    }

    public OOWWriter(String filename, OpenOfficeConnection connection) {
        this.setFilename(filename);
        this.connection = connection;
    }

    public void init() throws Exception {
        super.init();
    }

    public void shutdown() throws Exception {
        super.shutdown();
    }

    private XText getCurrentText() {
        return this.headerProcessing ? this.textDocument.getTextHeader() : (this.footerProcessing ? this.textDocument.getTextFooter() : this.textDocument.getTextContent());
    }

    private XTextCursor getCurrentTextCursor() {
        return this.headerProcessing ? this.textDocument.getHeaderCursor() : (this.footerProcessing ? this.textDocument.getFooterCursor() : this.textDocument.getTextCursor());
    }

    private XParagraphCursor getCurrentParagraphCursor() {
        return this.headerProcessing ? this.textDocument.getHeaderParagraphCursor() : (this.footerProcessing ? this.textDocument.getFooterParagraphCursor() : this.textDocument.getParagraphCursor());
    }

    public void onStartDocument() throws Exception {
        this.textDocument = new TextDocument(this.connection);
        PipeLine pipeLine = this.getPipeLine();
        String templ = null;
        if (pipeLine != null) {
            templ = pipeLine.getTemplate();
        }
        this.textDocument.create(templ);
    }

    public void onEndDocument() throws Exception {
        this.textDocument.saveAs(this.file, this.saveFormat);
        this.textDocument.close();
        this.textDocument = null;
    }

    public void onDocumentProperties(DocumentMetadata properties) throws Exception {
        this.textDocument.setDocumentMetadata(properties);
    }

    public void onStartBlock(String id, TextMetrics metrics, String headlineText) throws Exception {
        String text = headlineText.replaceAll("\r$", "");
        this.textDocument.insertText(this.textDocument.getTextContent(), this.textDocument.getParagraphCursor(), text, null);
        this.applyParagraphStyle(metrics);
        this.textDocument.createParagraph(this.textDocument.getTextCursor(), this.textDocument.getParagraphCursor(), this.textDocument.getTextContent());
    }

    public void onEndBlock() throws Exception {
    }

    public void onStartParagraph(String id, TextMetrics metrics) throws Exception {
        this.applyParagraphStyle(metrics);
    }

    public void onEndParagraph() throws Exception {
        this.textDocument.createParagraph(this.getCurrentTextCursor(), this.getCurrentParagraphCursor(), this.getCurrentText());
    }

    public void onText(TextMetrics metrics, String text, boolean applyMetrics) throws Exception {
        String textStr = text.replaceAll("\r$", "");
        this.textDocument.insertText(this.getCurrentText(), this.getCurrentParagraphCursor(), textStr, metrics);
    }

    public void setSaveFormat(String saveFormat) {
        this.saveFormat = saveFormat;
    }

    private void applyParagraphStyle(TextMetrics metrics) throws Exception {
        TextMetrics m = metrics;
        String styleName = metrics.getStyleName();
        HashMap styles = this.textDocument.getStyles();
        PipeLine pipeline = this.getPipeLine();
        if (StringUtils.isNotBlank((String)styleName) && !styles.containsKey(styleName) && pipeline.isSearchEnabled()) {
            String styleFormat = StringUtils.replace((String)pipeline.getSearchFormat(), (String)"${style}", (String)styleName);
            Pattern pat = Pattern.compile(styleFormat);
            for (String sName : styles.keySet()) {
                if (!pat.matcher(sName).matches()) continue;
                m = metrics.clone();
                m.setStyleName(sName);
                break;
            }
        }
        this.textDocument.applyParagraphStyle(this.getCurrentParagraphCursor(), m);
    }
}

