/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.imcode.imcms.addon.DocumentConverter.ConvertInfo;
import com.imcode.imcms.addon.DocumentConverter.ConverterUtils;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.StyleNameResolver;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter
implements Serializable {
    private static final long serialVersionUID = -6619599633513822065L;
    private static final Log log = LogFactory.getLog(Converter.class);
    private OpenOfficeConnection connection;
    private String templateName;
    private String searchFormat;
    private boolean isSearchEnabled;
    private StyleNameResolver blockNameResolver;

    public Converter(OpenOfficeConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(ConvertInfo from, List<ConvertInfo> to) {
        PipeLine pipeLine = null;
        try {
            pipeLine = this.buildPipeLine(from, to);
            pipeLine.execute();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            if (pipeLine != null) {
                try {
                    pipeLine.shutdown();
                }
                catch (Exception e) {}
                pipeLine.clear();
            }
        }
    }

    protected PipeLine buildPipeLine(ConvertInfo from, List<ConvertInfo> to) throws Exception {
        PipeLine pipeLine = new PipeLine();
        pipeLine.setConnection(this.connection);
        pipeLine.setReader(ConverterUtils.createContentReader(from, this.connection));
        for (ConvertInfo output : to) {
            pipeLine.addWriter(ConverterUtils.createContentWriter(output, this.connection));
        }
        pipeLine.init();
        pipeLine.setSearchEnabled(this.isSearchEnabled);
        pipeLine.setSearchFormat(this.searchFormat);
        pipeLine.setTemplate(this.templateName);
        pipeLine.setBlockNameResolver(this.blockNameResolver);
        return pipeLine;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setSearchFormat(String searchFormat) {
        this.searchFormat = searchFormat;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.isSearchEnabled = searchEnabled;
    }

    public void setBlockNameResolver(StyleNameResolver blockNameResolver) {
        this.blockNameResolver = blockNameResolver;
    }
}

