/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.DocumentConverter;

import com.imcode.imcms.addon.DocumentConverter.ConverterUtils;
import com.imcode.imcms.addon.DocumentConverter.DocumentMetadata;
import com.imcode.imcms.addon.DocumentConverter.EventGenerator;
import com.imcode.imcms.addon.DocumentConverter.EventListener;
import com.imcode.imcms.addon.DocumentConverter.PipeLine;
import com.imcode.imcms.addon.DocumentConverter.TextMetrics;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentReader
implements EventGenerator {
    private Collection<EventListener> listeners;
    private String filename;
    private File file;
    private boolean isInitialized = false;
    private PipeLine pipeLine;

    public PipeLine getPipeLine() {
        return this.pipeLine;
    }

    public void setPipeLine(PipeLine pipeLine) {
        this.pipeLine = pipeLine;
    }

    @Override
    public void init() throws Exception {
        if (this.filename != null) {
            File file = ConverterUtils.getFile(this.filename);
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("Could not find file \"" + this.filename + "\"");
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("File \"" + this.filename + "\" is not a file");
            }
            this.file = file;
        }
        this.isInitialized = true;
    }

    @Override
    public void start() throws Exception {
        if (!this.isInitialized) {
            throw new RuntimeException("Content reader for \"" + this.filename + "\" is not initialized");
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.file = null;
        this.isInitialized = false;
    }

    public synchronized void setEventListeners(Collection<EventListener> listeners) {
        this.listeners = listeners;
    }

    protected void setFilename(String filename) {
        this.filename = FilenameUtils.separatorsToSystem((String)filename);
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public void startDocument() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartDocument();
        }
    }

    @Override
    public void endDocument() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndDocument();
        }
    }

    @Override
    public void documentProperties(DocumentMetadata properties) throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onDocumentProperties(properties);
        }
    }

    @Override
    public void startHeader() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartHeader();
        }
    }

    @Override
    public void endHeader() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndHeader();
        }
    }

    @Override
    public void startBlock(String id, TextMetrics metrics, String headlineText) throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartBlock(id, metrics, headlineText);
        }
    }

    @Override
    public void endBlock() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndBlock();
        }
    }

    @Override
    public void startText(String id, TextMetrics metrics) throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartText(id, metrics);
        }
    }

    @Override
    public void endText() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndText();
        }
    }

    @Override
    public void startParagraph(String id, TextMetrics metrics) throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartParagraph(id, metrics);
        }
    }

    @Override
    public void endParagraph() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndParagraph();
        }
    }

    @Override
    public void text(TextMetrics metrics, String text, boolean applyMetrics) throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onText(metrics, text, applyMetrics);
        }
    }

    @Override
    public void startFooter() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onStartFooter();
        }
    }

    @Override
    public void endFooter() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.onEndFooter();
        }
    }
}

