/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlQueryDatabaseCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.handlers.ObjectArrayHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.addon.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.addon.db.StringArrayResultSetHandler;
import com.imcode.imcms.addon.db.StringFromRowFactory;
import com.imcode.imcms.api.DatabaseService;
import imcode.server.Imcms;
import org.apache.commons.dbutils.ResultSetHandler;

public class DBUtil {
    Database db;

    public DBUtil(DatabaseService dbService) {
        try {
            this.db = Imcms.getServices().getDatabase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int sqlUpdateQuery(String sql, Object[] parameters) throws DatabaseException {
        return this.executeUpdate(sql, parameters);
    }

    public String sqlQueryStr(String sql, Object[] parameters) throws DatabaseException {
        return this.executeStringQuery(sql, parameters);
    }

    public String[] sqlQueryString(String sql, Object[] parameters) throws DatabaseException {
        return this.executeStringArrayQuery(sql, parameters);
    }

    public String[] sqlQuery(String sql, Object[] parameters) throws DatabaseException {
        return this.executeStringArrayQuery(sql, parameters);
    }

    public String[][] sqlQueryMulti(String sql, Object[] parameters) throws DatabaseException {
        return this.execute2dStringArrayQuery(sql, parameters);
    }

    public String executeStringQuery(String sql, Object[] parameters) throws DatabaseException {
        return (String)this.db.execute((DatabaseCommand)new SqlQueryDatabaseCommand(sql, parameters, (ResultSetHandler)new SingleObjectHandler((RowTransformer)new StringFromRowFactory())));
    }

    public String[] executeStringArrayQuery(String sql, Object[] parameters) throws DatabaseException {
        return (String[])this.db.execute((DatabaseCommand)new SqlQueryDatabaseCommand(sql, parameters, (ResultSetHandler)new StringArrayResultSetHandler()));
    }

    public String[][] execute2dStringArrayQuery(String sql, Object[] parameters) throws DatabaseException {
        return (String[][])this.db.execute((DatabaseCommand)new SqlQueryDatabaseCommand(sql, parameters, (ResultSetHandler)new StringArrayArrayResultSetHandler()));
    }

    public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
        return (Integer)this.db.execute((DatabaseCommand)new SqlUpdateCommand(sql, parameters));
    }

    public Object executeObjectQuery(String sql, String[] parameters, RowTransformer objectFromRowFactory) {
        return this.db.execute((DatabaseCommand)new SqlQueryDatabaseCommand(sql, (Object[])parameters, (ResultSetHandler)new SingleObjectHandler(objectFromRowFactory)));
    }

    public Object[] executeObjectArrayQuery(String sql, String[] parameters, RowTransformer objectFromRowFactory) {
        return (Object[])this.db.execute((DatabaseCommand)new SqlQueryDatabaseCommand(sql, (Object[])parameters, (ResultSetHandler)new ObjectArrayHandler(objectFromRowFactory)));
    }

    public Database getDatabase() {
        return this.db;
    }
}

