/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.gateway;

import com.imcode.cart.CheckStatus;
import com.imcode.cart.ShoppingCartWebService;
import com.imcode.cart.ShoppingCartWebServiceService;
import com.imcode.cart.UpdateStatus;
import com.imcode.gateway.CartItem;
import com.imcode.gateway.CartUser;
import com.imcode.gateway.ConfigUtils;
import com.imcode.server.Gateway;
import com.imcode.server.GatewayService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;

public class ShoppingCart {
    private ShoppingCartWebService port;
    private static Gateway gateway = null;
    private static ShoppingCartWebServiceService cartService = null;

    public static ShoppingCart getShoppingCart(String uniqueKey) {
        ShoppingCartWebService c = (ShoppingCartWebService)cartService.getPort((EndpointReference)gateway.getCart(uniqueKey), ShoppingCartWebService.class, new WebServiceFeature[0]);
        return new ShoppingCart(c);
    }

    public static ShoppingCart createNewShoppingCart(String username, String backToClientSiteURL, String hiddenConfirmationRequestToClientURL) {
        ShoppingCartWebService c1 = (ShoppingCartWebService)cartService.getPort((EndpointReference)gateway.createCart(username, "", backToClientSiteURL, hiddenConfirmationRequestToClientURL), ShoppingCartWebService.class, new WebServiceFeature[0]);
        return new ShoppingCart(c1);
    }

    protected ShoppingCart(ShoppingCartWebService port) {
        this.port = port;
    }

    public int getId() {
        return this.port.getId();
    }

    public List<CartItem> getItems() {
        ArrayList<CartItem> items = new ArrayList<CartItem>();
        List<Integer> ids = this.port.getItems(this.getId());
        for (int i : ids) {
            CartItem item = CartItem.getExisting(i);
            items.add(item);
        }
        return items;
    }

    public void setPageId(int id) {
        this.port.setPageId(id);
    }

    public String getPayExFormURL(String baseUrl) {
        return this.port.getGatewayFormURL(baseUrl);
    }

    public String getUniqueKey() {
        return this.port.getUniqueKey();
    }

    public CartUser getCartUser(Integer id) {
        Integer userId = this.port.getCartUserId();
        if (userId == null) {
            return null;
        }
        return CartUser.getExisting(userId);
    }

    public void setCartUser(int id) {
        this.port.setUser(id);
    }

    public void setBackToSiteURL(String url) {
        this.port.setBackToClientSiteURL(url);
    }

    public void setHiddenConfirmationRequestToClient(String url) {
        this.port.setHiddenConfirmationRequestToClientURL(url);
    }

    public CheckStatus checkStatus() {
        return this.port.getTransactionStatus();
    }

    public String getExtraInfo() {
        return this.port.getExtraInfo();
    }

    public void setExtraInfo(String info) {
        this.port.setExtraInfo(info);
    }

    public static List<String> getPriceCategoryNames() {
        return gateway.getPriceCategoryNames(ConfigUtils.GATEWAY_MERCHANT_LOGIN_NAME);
    }

    public void setUpdated(UpdateStatus updateStatus, String description) {
        this.port.setUpdated(updateStatus, description);
    }

    public static List<ShoppingCart> getCartsForExternalUser(int userId, Date lower, Date upper) throws DatatypeConfigurationException {
        ArrayList<ShoppingCart> carts = new ArrayList<ShoppingCart>();
        XMLGregorianCalendar lowerDt = null;
        if (lower != null) {
            GregorianCalendar tmp = new GregorianCalendar();
            tmp.setTime(lower);
            lowerDt = DatatypeFactory.newInstance().newXMLGregorianCalendar(tmp);
        }
        XMLGregorianCalendar upperDt = null;
        if (upper != null) {
            GregorianCalendar tmp = new GregorianCalendar();
            tmp.setTime(upper);
            upperDt = DatatypeFactory.newInstance().newXMLGregorianCalendar(tmp);
        }
        List<String> ids = gateway.getCartKeysForExtUser(userId, lowerDt, upperDt, ConfigUtils.GATEWAY_MERCHANT_LOGIN_NAME);
        for (String id : ids) {
            carts.add(ShoppingCart.getShoppingCart(id));
        }
        return carts;
    }

    static {
        try {
            gateway = new GatewayService(new URL(ConfigUtils.GATEWAY_WEBSERVICES_URL_BASE + "Gateway?wsdl"), new QName("http://server.imcode.com/", "GatewayService")).getGatewayPort();
            cartService = new ShoppingCartWebServiceService(new URL(ConfigUtils.GATEWAY_WEBSERVICES_URL_BASE + "ShoppingCartWebService?wsdl"), new QName("http://cart.imcode.com/", "ShoppingCartWebServiceService"));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ShoppingCart.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

