/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth.ui;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.util.StringUtil;
import com.twitterapime.xauth.OAuthSigner;
import com.twitterapime.xauth.Token;
import com.twitterapime.xauth.ui.OAuthDialogListener;
import java.io.IOException;

public abstract class OAuthDialogWrapper {
    public static final String OAUTH_REQUEST_TOKEN_FAILED = "oauth_request_token_failed";
    public static final String OAUTH_IO_FAILED = "oauth_io_exception";
    public static final String OAUTH_ACCESS_TOKEN_FAILED = "oauth_access_token_failed";
    public static final String OAUTH_ACCESS_TOKEN_DENIED = "oauth_access_token_denied";
    protected String consumerKey;
    protected String consumerSecret;
    protected String callbackUrl;
    protected OAuthDialogListener oauthListener;
    protected OAuthSigner signer;
    protected Token token;
    protected String requestTokenUrl = "https://api.twitter.com/oauth/request_token";
    protected String loginPageUrl = "https://api.twitter.com/oauth/authorize";
    protected String accessTokenUrl = "https://api.twitter.com/oauth/access_token";
    protected boolean enableCustomResultPages;
    protected String successPageHtml;
    protected String deniedPageHtml;
    protected String errorPageHtml;

    protected OAuthDialogWrapper(String consumerKey, String consumerSecret, String callbackUrl, OAuthDialogListener authListener) {
        this.setConsumerKey(consumerKey);
        this.setConsumerSecret(consumerSecret);
        this.setCallbackUrl(callbackUrl);
        this.setEnableCustomResultPages(true);
        this.setOAuthListener(authListener);
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = StringUtil.isEmpty(callbackUrl) ? "oob" : callbackUrl;
    }

    public void setRequestTokenUrl(String requestTokenUrl) {
        this.requestTokenUrl = requestTokenUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setEnableCustomResultPages(boolean enabled) {
        this.enableCustomResultPages = enabled;
    }

    public void setCustomSuccessPageHtml(String html) {
        this.successPageHtml = html;
    }

    public void setCustomDeniedPageHtml(String html) {
        this.deniedPageHtml = html;
    }

    public void setCustomErrorPageHtml(String html) {
        this.errorPageHtml = html;
    }

    public void setOAuthListener(OAuthDialogListener listener) {
        this.oauthListener = listener;
    }

    public void login() {
        if (StringUtil.isEmpty(this.consumerKey)) {
            throw new IllegalArgumentException("Consumer Key must not be null.");
        }
        if (StringUtil.isEmpty(this.consumerSecret)) {
            throw new IllegalArgumentException("Consumer Secret must not be null.");
        }
        if (StringUtil.isEmpty(this.callbackUrl)) {
            throw new IllegalArgumentException("Callback Url must not be null.");
        }
        this.token = null;
        this.signer = new OAuthSigner(this.consumerKey, this.consumerSecret);
        new Thread(){

            public void run() {
                OAuthDialogWrapper.this.requestToken();
            }
        }.start();
    }

    public void login(final String pinCode) {
        if (StringUtil.isEmpty(pinCode)) {
            throw new IllegalArgumentException("PIN-code must not be null.");
        }
        if (this.token == null) {
            throw new IllegalStateException("Invalid state: call login() method first.");
        }
        new Thread(){

            public void run() {
                OAuthDialogWrapper.this.trackUrl(OAuthDialogWrapper.this.callbackUrl + "?oauth_verifier=" + pinCode);
            }
        }.start();
    }

    protected abstract void loadUrl(String var1);

    protected abstract void loadHTML(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestToken() {
        HttpRequest req = new HttpRequest(this.requestTokenUrl);
        this.signer.signForRequestToken(req, this.callbackUrl);
        try {
            HttpResponse resp = req.send();
            String body = resp.getBodyContent();
            if (resp.getCode() != 200) {
                this.displayOAuthErrorPage(OAUTH_REQUEST_TOKEN_FAILED, body);
                this.triggerOnFail(OAUTH_REQUEST_TOKEN_FAILED, body);
                return;
            }
            String conf = StringUtil.getUrlParamValue(body, "oauth_callback_confirmed");
            if ("true".equals(conf)) {
                this.token = Token.parse(body);
                String oauthUrl = this.loginPageUrl + "?oauth_token=" + this.token.getToken() + "&force_login=true";
                this.loadUrl(oauthUrl);
            } else {
                this.displayOAuthErrorPage(OAUTH_REQUEST_TOKEN_FAILED, body);
                this.triggerOnFail(OAUTH_REQUEST_TOKEN_FAILED, body);
            }
        }
        catch (IOException e) {
            this.displayOAuthErrorPage(OAUTH_IO_FAILED, e.getMessage());
            this.triggerOnFail(OAUTH_IO_FAILED, e.getMessage());
        }
        finally {
            try {
                req.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackUrl(String url) {
        if (url.startsWith(this.callbackUrl) && this.oauthListener != null) {
            if (url.indexOf("oauth_verifier=") != -1) {
                String verifier = StringUtil.getUrlParamValue(url, "oauth_verifier");
                HttpRequest req = new HttpRequest(this.accessTokenUrl);
                this.signer.signForAccessToken(req, this.token, verifier);
                try {
                    HttpResponse resp = req.send();
                    String body = resp.getBodyContent();
                    if (resp.getCode() == 200) {
                        this.displayOAuthSuccessPage();
                        this.token = Token.parse(body);
                        this.triggerOnAuthorize(this.token);
                    }
                    this.displayOAuthErrorPage(OAUTH_ACCESS_TOKEN_FAILED, body);
                    this.triggerOnFail(OAUTH_ACCESS_TOKEN_FAILED, body);
                }
                catch (IOException e) {
                    this.displayOAuthErrorPage(OAUTH_IO_FAILED, e.getMessage());
                    this.triggerOnFail(OAUTH_IO_FAILED, e.getMessage());
                }
                finally {
                    try {
                        req.close();
                    }
                    catch (IOException e) {}
                }
            } else if (url.indexOf("denied=") != -1) {
                this.displayOAuthDeniedPage("Access Denied");
                this.triggerOnAccessDenied(OAUTH_ACCESS_TOKEN_DENIED);
            }
        }
    }

    protected void displayOAuthSuccessPage() {
        if (this.enableCustomResultPages) {
            String html = "<html><body><center><font color=\"blue\"><br/><b>Twitter</b></font></center><br/><center>Authorization granted!<br/><br/>Close this page.</center></body></html>";
            if (this.successPageHtml != null) {
                html = this.successPageHtml;
            }
            this.loadHTML(html);
        }
    }

    protected void displayOAuthDeniedPage(String message) {
        if (this.enableCustomResultPages) {
            String html = "<html><body><center><font color=\"blue\"><br/><b>Twitter</b></font></center><br/><center>Authorization denied: " + message + "<br/><br/>Close this page.</center>" + "</body></html>";
            if (this.deniedPageHtml != null) {
                html = this.deniedPageHtml;
            }
            this.loadHTML(html);
        }
    }

    protected void displayOAuthErrorPage(String error, String message) {
        if (this.enableCustomResultPages) {
            String html = "<html><body><center><font color=\"blue\"><br/><b>Twitter</b></font></center><br/><center>Authorization failed: " + message + " (" + error + ")" + "<br/><br/>Close this page.</center>" + "</body></html>";
            if (this.errorPageHtml != null) {
                html = this.errorPageHtml;
            }
            this.loadHTML(html);
        }
    }

    protected void triggerOnAuthorize(Token accessToken) {
        if (this.oauthListener != null) {
            this.oauthListener.onAuthorize(accessToken);
        }
    }

    protected void triggerOnFail(String error, String message) {
        if (this.oauthListener != null) {
            this.oauthListener.onFail(error, message);
        }
    }

    protected void triggerOnAccessDenied(String message) {
        if (this.oauthListener != null) {
            this.oauthListener.onAccessDenied(message);
        }
    }
}

