/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.xauth.OAuthParameters;
import com.twitterapime.xauth.OAuthSigner;

public final class XAuthSigner
extends OAuthSigner {
    public XAuthSigner(String consumerKey, String consumerSecret) {
        super(consumerKey, consumerSecret);
    }

    public void signForAccessToken(HttpRequest req, String username, String password) {
        req.setMethod("POST");
        req.setBodyParameter("x_auth_mode", "client_auth");
        req.setBodyParameter("x_auth_username", username);
        req.setBodyParameter("x_auth_password", password);
        OAuthParameters params = new OAuthParameters(this.consumerKey);
        String str = this.getSignatureBaseString(req, params);
        str = OAuthSigner.getSignature(str, this.consumerSecret, "");
        params.put("oauth_signature", str);
        str = params.getAuthorizationHeaderValue();
        req.setHeaderField("Authorization", str);
    }
}

