/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;

public final class StringUtil {
    private static final String[] MONTHS_ABBREVIATION = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static long convertTweetDateToLong(String date) {
        if (date == null || (date = date.trim()).length() == 0) {
            throw new IllegalArgumentException("Date must not be null/empty.");
        }
        char fc = date.charAt(0);
        date = Character.isDigit(fc) ? StringUtil.formatTweetDate1(date) : StringUtil.formatTweetDate2(date);
        String[] parts = StringUtil.split(date, ' ');
        String[] dparts = StringUtil.split(parts[0], '-');
        String[] tparts = StringUtil.split(parts[1], ':');
        Calendar c = Calendar.getInstance();
        c.set(1, Integer.parseInt(dparts[0]));
        c.set(2, Integer.parseInt(dparts[1]) - 1);
        c.set(5, Integer.parseInt(dparts[2]));
        c.set(11, Integer.parseInt(tparts[0]));
        c.set(12, Integer.parseInt(tparts[1]));
        c.set(13, Integer.parseInt(tparts[2]));
        c.set(14, 0);
        return c.getTime().getTime();
    }

    public static final String[] split(String str, char delimiter) {
        int iof;
        if (str == null) {
            throw new IllegalArgumentException("Str must not be null.");
        }
        Vector<String> v = new Vector<String>();
        int start = 0;
        while ((iof = str.indexOf(delimiter, start)) != -1) {
            v.addElement(str.substring(start, iof).trim());
            start = iof + 1;
        }
        v.addElement(str.substring(start, str.length()).trim());
        Object[] codes = new String[v.size()];
        v.copyInto(codes);
        return codes;
    }

    public static String formatTweetID(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID must not be null.");
        }
        int idx = id.lastIndexOf(58);
        if (idx != -1) {
            return id.substring(idx + 1, id.length());
        }
        return id;
    }

    public static String removeTags(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Str must not be null.");
        }
        StringBuffer out = new StringBuffer();
        char[] cs = str.toCharArray();
        boolean tagFound = false;
        int i1 = 0;
        int l = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '<' && !tagFound) {
                out.append(cs, i1, l);
                i1 = i;
                l = 0;
                tagFound = true;
                ++l;
                continue;
            }
            if (cs[i] == '>' && tagFound) {
                i1 = i + 1;
                l = 0;
                tagFound = false;
                continue;
            }
            ++l;
        }
        if (l > 0) {
            out.append(cs, i1, l);
        }
        return out.toString().trim();
    }

    public static String[] splitTweetAuthorNames(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        String[] names = new String[2];
        int i = (name = name.trim()).indexOf(32);
        if (i == -1) {
            names[0] = name;
            names[1] = name;
        } else {
            names[0] = name.substring(0, i);
            names[1] = name.substring(i + 2, name.length() - 1);
        }
        return names;
    }

    public static String zeroPad(int n, int len) {
        String s = n + "";
        for (int i = len - s.length(); i > 0; --i) {
            s = '0' + s;
        }
        return s;
    }

    public static String encode(String s) {
        return StringUtil.encode(s, null);
    }

    public static String encode(String s, String enc) {
        ByteArrayInputStream bIn;
        if (s == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        try {
            bIn = new ByteArrayInputStream(s.getBytes(enc));
        }
        catch (UnsupportedEncodingException e) {
            bIn = new ByteArrayInputStream(s.getBytes());
        }
        int c = bIn.read();
        StringBuffer ret = new StringBuffer();
        while (c >= 0) {
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 46 || c == 45 || c == 95) {
                ret.append((char)c);
            } else if (c == 32) {
                ret.append("%20");
            } else if (c < 128) {
                ret.append(StringUtil.getHexChar(c));
            } else if (c < 224) {
                ret.append(StringUtil.getHexChar(c));
                ret.append(StringUtil.getHexChar(bIn.read()));
            } else if (c < 240) {
                ret.append(StringUtil.getHexChar(c));
                ret.append(StringUtil.getHexChar(bIn.read()));
                ret.append(StringUtil.getHexChar(bIn.read()));
            }
            c = bIn.read();
        }
        return ret.toString();
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final String replace(String text, String searchStr, String replacementStr) {
        if (text == null) {
            throw new IllegalArgumentException("Text must not be null.");
        }
        if (searchStr == null) {
            throw new IllegalArgumentException("Search string must not be null.");
        }
        if (replacementStr == null) {
            throw new IllegalArgumentException("Replacement string must not be null.");
        }
        if (text.length() == 0 || searchStr.length() == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int searchStringPos = text.indexOf(searchStr);
        int startPos = 0;
        int searchStringLength = searchStr.length();
        while (searchStringPos != -1) {
            sb.append(text.substring(startPos, searchStringPos)).append(replacementStr);
            startPos = searchStringPos + searchStringLength;
            searchStringPos = text.indexOf(searchStr, startPos);
        }
        sb.append(text.substring(startPos, text.length()));
        return sb.toString();
    }

    public static String getUrlParamValue(String url, String param) {
        int ix = url.indexOf(63);
        if (ix != -1) {
            url = url.substring(ix + 1);
        }
        String[] params = StringUtil.split(url, '&');
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].startsWith(param + '=')) continue;
            return StringUtil.split(params[i], '=')[1];
        }
        return null;
    }

    private StringUtil() {
    }

    private static String formatTweetDate1(String date) {
        return date.substring(0, 10) + ' ' + date.substring(11, 19);
    }

    private static String formatTweetDate2(String date) {
        String[] dtps = StringUtil.split(date, ' ');
        String mon = dtps[1].toLowerCase();
        for (int i = 0; i < MONTHS_ABBREVIATION.length; ++i) {
            if (!mon.equals(MONTHS_ABBREVIATION[i])) continue;
            return dtps[5] + '-' + StringUtil.zeroPad(i + 1, 2) + '-' + dtps[2] + ' ' + dtps[3];
        }
        throw new IllegalArgumentException("Invalid date format: " + date);
    }

    private static String getHexChar(int c) {
        return (c < 16 ? "%0" : "%") + Integer.toHexString(c).toUpperCase();
    }
}

