/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search.handler;

import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.search.TweetEntity;
import java.util.Hashtable;
import java.util.Vector;

public final class TweetEntityHandler {
    private Hashtable userAccountData;
    private Hashtable urlData;
    private Hashtable mediaData;

    public void populate(Hashtable data, String path, String text) {
        if (path.endsWith("/user_mentions/user_mention/id")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_MENTIONS");
            this.userAccountData = new Hashtable();
            this.userAccountData.put("TWEETENTITY_USERACCOUNT_ID", text);
            v.addElement(new TweetEntity(this.userAccountData));
        } else if (path.endsWith("/user_mentions/user_mention/screen_name")) {
            if (this.userAccountData != null) {
                this.userAccountData.put("TWEETENTITY_USERACCOUNT_USER_NAME", text);
            }
        } else if (path.endsWith("/user_mentions/user_mention/name")) {
            if (this.userAccountData != null) {
                this.userAccountData.put("TWEETENTITY_USERACCOUNT_NAME", text);
            }
        } else if (path.endsWith("/urls/url/url")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_URLS");
            this.urlData = new Hashtable();
            this.urlData.put("TWEETENTITY_URL", text);
            v.addElement(new TweetEntity(this.urlData));
        } else if (path.endsWith("/urls/url/display_url")) {
            if (this.urlData != null) {
                this.urlData.put("TWEETENTITY_DISPLAY_URL", text);
            }
        } else if (path.endsWith("/urls/url/expanded_url")) {
            if (this.urlData != null) {
                this.urlData.put("TWEETENTITY_EXPANDED_URL", text);
            }
        } else if (path.endsWith("/media/creative/media_url")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_MEDIAS");
            this.mediaData = new Hashtable();
            this.mediaData.put("TWEETENTITY_MEDIA", text);
            v.addElement(new TweetEntity(this.mediaData));
        } else if (path.endsWith("/media/creative/display_url")) {
            if (this.mediaData != null) {
                this.mediaData.put("TWEETENTITY_DISPLAY_URL", text);
            }
        } else if (path.endsWith("/media/creative/url")) {
            if (this.mediaData != null) {
                this.mediaData.put("TWEETENTITY_URL", text);
            }
        } else if (path.endsWith("/hashtags/hashtag/text")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_HASHTAGS");
            Hashtable<String, String> t = new Hashtable<String, String>();
            t.put("TWEETENTITY_HASHTAG", text);
            v.addElement(new TweetEntity(t));
        }
    }

    public void populate(Hashtable data, JSONObject jsonObj) {
        Hashtable t;
        JSONObject obj;
        int i;
        if (jsonObj.has("user_mentions")) {
            JSONArray jsonMentions = jsonObj.getJSONArray("user_mentions");
            Vector<TweetEntity> mentions = new Vector<TweetEntity>(jsonMentions.length());
            for (i = 0; i < jsonMentions.length(); ++i) {
                obj = jsonMentions.getJSONObject(i);
                t = new Hashtable();
                this.putIf(t, "TWEETENTITY_USERACCOUNT_ID", obj, "id");
                this.putIf(t, "TWEETENTITY_USERACCOUNT_USER_NAME", obj, "screen_name");
                this.putIf(t, "TWEETENTITY_USERACCOUNT_NAME", obj, "name");
                if (t.size() <= 0) continue;
                mentions.addElement(new TweetEntity(t));
            }
            if (mentions.size() > 0) {
                data.put("TWEETENTITY_MENTIONS", mentions);
            }
        }
        if (jsonObj.has("media")) {
            JSONArray jsonMedias = jsonObj.getJSONArray("media");
            Vector<TweetEntity> medias = new Vector<TweetEntity>(jsonMedias.length());
            for (i = 0; i < jsonMedias.length(); ++i) {
                obj = jsonMedias.getJSONObject(i);
                t = new Hashtable();
                this.putIf(t, "TWEETENTITY_MEDIA", obj, "media_url");
                this.putIf(t, "TWEETENTITY_DISPLAY_URL", obj, "display_url");
                if (t.size() <= 0) continue;
                medias.addElement(new TweetEntity(t));
            }
            if (medias.size() > 0) {
                data.put("TWEETENTITY_MEDIAS", medias);
            }
        }
        if (jsonObj.has("urls")) {
            JSONArray jsonUrls = jsonObj.getJSONArray("urls");
            Vector<TweetEntity> urls = new Vector<TweetEntity>(jsonUrls.length());
            for (i = 0; i < jsonUrls.length(); ++i) {
                obj = jsonUrls.getJSONObject(i);
                t = new Hashtable();
                this.putIf(t, "TWEETENTITY_URL", obj, "url");
                this.putIf(t, "TWEETENTITY_DISPLAY_URL", obj, "display_url");
                this.putIf(t, "TWEETENTITY_EXPANDED_URL", obj, "expanded_url");
                if (t.size() <= 0) continue;
                urls.addElement(new TweetEntity(t));
            }
            if (urls.size() > 0) {
                data.put("TWEETENTITY_URLS", urls);
            }
        }
        if (jsonObj.has("hashtags")) {
            JSONArray jsonHashtags = jsonObj.getJSONArray("hashtags");
            Vector<TweetEntity> hashtags = new Vector<TweetEntity>(jsonHashtags.length());
            for (i = 0; i < jsonHashtags.length(); ++i) {
                obj = jsonHashtags.getJSONObject(i);
                t = new Hashtable();
                this.putIf(t, "TWEETENTITY_HASHTAG", obj, "text");
                if (t.size() <= 0) continue;
                hashtags.addElement(new TweetEntity(t));
            }
            if (hashtags.size() > 0) {
                data.put("TWEETENTITY_HASHTAGS", hashtags);
            }
        }
    }

    private void putIf(Hashtable data, String dataKey, JSONObject jsonObj, String jsonKey) {
        if (jsonObj.has(jsonKey)) {
            data.put(dataKey, jsonObj.getString(jsonKey));
        }
    }

    private Vector getOrCreateIfNecessary(Hashtable data, String key) {
        Vector v = (Vector)data.get(key);
        if (v == null) {
            v = new Vector();
            data.put(key, v);
        }
        return v;
    }
}

