/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search.handler;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.search.Topic;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class TrendTopicsWoeidHandler
extends DefaultJSONHandler {
    public TrendTopicsWoeidHandler() {
        super("root");
    }

    public Topic[] getParsedTopics() {
        if (this.content != null && this.content.size() > 0) {
            String timestamp = this.content.get("created_at").toString();
            if (timestamp.length() == 10) {
                timestamp = timestamp + " 00:00:00";
            } else if (timestamp.length() == 16) {
                timestamp = timestamp + ":00";
            }
            timestamp = StringUtil.convertTweetDateToLong(timestamp) + "";
            Object[] tss = (Object[])this.content.get("trends");
            Vector<Topic> topics = new Vector<Topic>(tss.length);
            for (int i = 0; i < tss.length; ++i) {
                Hashtable data = (Hashtable)tss[i];
                String name = (String)data.get("name");
                String query = (String)data.get("query");
                String url = (String)data.get("url");
                String promoted = (String)data.get("promoted_content");
                data.clear();
                data.put("TOPIC_DATE", timestamp);
                if (!this.isEmpty(name)) {
                    data.put("TOPIC_TEXT", name);
                }
                if (!this.isEmpty(query)) {
                    data.put("TOPIC_QUERY", query);
                }
                if (!this.isEmpty(url)) {
                    data.put("TOPIC_URL", url);
                }
                if (!this.isEmpty(promoted)) {
                    data.put("TOPIC_PROMOTED", promoted);
                }
                topics.addElement(new Topic(data));
            }
            Object[] topicsArray = new Topic[topics.size()];
            topics.copyInto(topicsArray);
            return topicsArray;
        }
        return new Topic[0];
    }
}

