/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search.handler;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.search.Topic;
import com.twitterapime.util.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class TrendTopicsHandler
extends DefaultJSONHandler {
    public TrendTopicsHandler() {
        super("trends");
    }

    public Topic[] getParsedTopics() {
        if (this.content != null && this.content.size() > 0) {
            Enumeration keys = this.content.keys();
            Vector<Topic> topics = new Vector<Topic>(50);
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                System.out.println(key);
                Object[] tss = (Object[])this.content.get(key);
                if (key.length() == 10) {
                    key = key + " 00:00:00";
                } else if (key.length() == 16) {
                    key = key + ":00";
                }
                String time = StringUtil.convertTweetDateToLong(key) + "";
                for (int i = 0; i < tss.length; ++i) {
                    Hashtable data = (Hashtable)tss[i];
                    String name = (String)data.get("name");
                    String query = (String)data.get("query");
                    String url = (String)data.get("url");
                    String promoted = (String)data.get("promoted_content");
                    data.clear();
                    data.put("TOPIC_DATE", time);
                    if (!this.isEmpty(name)) {
                        data.put("TOPIC_TEXT", name);
                    }
                    if (!this.isEmpty(query)) {
                        data.put("TOPIC_QUERY", query);
                    }
                    if (!this.isEmpty(url)) {
                        data.put("TOPIC_URL", url);
                    }
                    if (!this.isEmpty(promoted)) {
                        data.put("TOPIC_PROMOTED", promoted);
                    }
                    topics.addElement(new Topic(data));
                }
            }
            Object[] topicsArray = new Topic[topics.size()];
            topics.copyInto(topicsArray);
            return topicsArray;
        }
        return new Topic[0];
    }
}

