/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search.handler;

import com.twitterapime.parser.Attributes;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class SearchResultHandler
extends DefaultXMLHandler {
    private SearchDeviceListener listener;
    private Vector tweetList = new Vector(15);
    private Tweet tweet;
    private Hashtable tweetValues;
    private Hashtable tweetUserValues;

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws ParserException {
        super.startElement(namespaceURI, localName, qName, attrs);
        localName = localName.toLowerCase();
        if (localName.equals("entry")) {
            this.tweet = new Tweet();
            this.tweetValues = new Hashtable(15);
            this.tweet.setData(this.tweetValues);
            this.tweetUserValues = new Hashtable(3);
            this.tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.tweetUserValues));
        } else if (localName.equals("link") && this.xmlPath.equals("/feed/entry/link")) {
            String attrValue = attrs.getValue("type");
            if (attrValue.equals("text/html")) {
                this.tweetValues.put("TWEET_URI", attrs.getValue("href"));
            } else if (attrValue.equals("image/png")) {
                this.tweetValues.put("TWEET_AUTHOR_PICTURE_URI", attrs.getValue("href"));
                this.tweetUserValues.put("USERACCOUNT_PICTURE_URI", attrs.getValue("href"));
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws ParserException {
        super.endElement(namespaceURI, localName, qName);
        if (localName.toLowerCase().equals("entry")) {
            this.tweetList.addElement(this.tweet);
            this.fireTweetParsed(this.tweet);
        }
    }

    public void text(String text) throws ParserException {
        if (this.xmlPath.equals("/feed/entry/id")) {
            this.tweetValues.put("TWEET_ID", StringUtil.formatTweetID(text));
        } else if (this.xmlPath.equals("/feed/entry/published")) {
            this.tweetValues.put("TWEET_PUBLISH_DATE", "" + StringUtil.convertTweetDateToLong(text));
        } else if (this.xmlPath.equals("/feed/entry/title")) {
            this.tweetValues.put("TWEET_CONTENT", text);
        } else if (this.xmlPath.equals("/feed/entry/twitter:source") || this.xmlPath.equals("/feed/entry/source")) {
            this.tweetValues.put("TWEET_SOURCE", StringUtil.removeTags(text));
        } else if (this.xmlPath.equals("/feed/entry/twitter:lang") || this.xmlPath.equals("/feed/entry/lang")) {
            this.tweetValues.put("TWEET_LANG", text);
        } else if (this.xmlPath.equals("/feed/entry/author/name")) {
            String[] names = StringUtil.splitTweetAuthorNames(text);
            this.tweetValues.put("TWEET_AUTHOR_USERNAME", names[0]);
            this.tweetValues.put("TWEET_AUTHOR_NAME", names[1]);
            this.tweetUserValues.put("USERACCOUNT_USER_NAME", names[0]);
            this.tweetUserValues.put("USERACCOUNT_NAME", names[1]);
            String picUri = "http://api.twitter.com/1/users/profile_image/" + names[0] + ".json?size=";
            this.tweetUserValues.put("USERACCOUNT_PICTURE_URI_MINI", picUri + "mini");
            this.tweetUserValues.put("USERACCOUNT_PICTURE_URI_NORMAL", picUri + "normal");
            this.tweetUserValues.put("USERACCOUNT_PICTURE_URI_BIGGER", picUri + "bigger");
        } else if (this.xmlPath.equals("/feed/entry/author/uri")) {
            this.tweetValues.put("TWEET_AUTHOR_URI", text);
        }
    }

    public Tweet[] getParsedTweets() {
        Object[] tweets = new Tweet[this.tweetList.size()];
        this.tweetList.copyInto(tweets);
        return tweets;
    }

    public void setSearchDeviceListener(SearchDeviceListener listener) {
        this.listener = listener;
    }

    private void fireTweetParsed(Tweet tweet) {
        if (this.listener != null) {
            this.listener.tweetFound(tweet);
        }
    }
}

