/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.search.Topic;
import com.twitterapime.search.handler.TrendTopicsHandler;
import com.twitterapime.search.handler.TrendTopicsWoeidHandler;
import com.twitterapime.util.StringUtil;
import java.io.IOException;
import java.util.Hashtable;

public final class TrendTopics {
    private static final Hashtable SERVICES_URL = new Hashtable(3);
    private static TrendTopics singleInstance;
    public static final String TWITTER_API_URL_SERVICE_TRENDS_CURRENT = "TWITTER_API_URL_SERVICE_TRENDS_CURRENT";
    public static final String TWITTER_API_URL_SERVICE_TRENDS_DAILY = "TWITTER_API_URL_SERVICE_TRENDS_DAILY";
    public static final String TWITTER_API_URL_SERVICE_TRENDS_WEEKLY = "TWITTER_API_URL_SERVICE_TRENDS_WEEKLY";
    public static final String TWITTER_API_URL_SERVICE_TRENDS_WOEID = "TWITTER_API_URL_SERVICE_TRENDS_WOEID";

    public static synchronized TrendTopics getInstance() {
        if (singleInstance == null) {
            singleInstance = new TrendTopics();
        }
        return singleInstance;
    }

    private TrendTopics() {
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public Topic[] searchNowTopics(Query query) throws IOException, LimitExceededException {
        return this.searchNowTopics("1", query);
    }

    public Topic[] searchNowTopics(String woeid, Query query) throws IOException, LimitExceededException {
        if (StringUtil.isEmpty(woeid)) {
            throw new IllegalArgumentException("Woeid must not be empty/null.");
        }
        String url = this.getURL(TWITTER_API_URL_SERVICE_TRENDS_WOEID);
        url = StringUtil.replace(url, ":woeid", woeid);
        if (query != null) {
            url = url + '?' + query.toString();
        }
        HttpRequest req = new HttpRequest(url);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            TrendTopicsWoeidHandler handler = new TrendTopicsWoeidHandler();
            parser.parse(resp.getStream(), handler);
            Topic[] topicArray = handler.getParsedTopics();
            return topicArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public Topic[] searchDailyTopics(Query query) throws IOException, LimitExceededException {
        return this.search(this.getURL(TWITTER_API_URL_SERVICE_TRENDS_DAILY), query);
    }

    public Topic[] searchWeeklyTopics(Query query) throws IOException, LimitExceededException {
        return this.search(this.getURL(TWITTER_API_URL_SERVICE_TRENDS_WEEKLY), query);
    }

    private Topic[] search(String url, Query query) throws IOException, LimitExceededException {
        if (query != null) {
            url = url + '?' + query.toString();
        }
        HttpRequest req = new HttpRequest(url);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            TrendTopicsHandler handler = new TrendTopicsHandler();
            parser.parse(resp.getStream(), handler);
            Topic[] topicArray = handler.getParsedTopics();
            return topicArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_TRENDS_WOEID, "http://api.twitter.com/1/trends/:woeid.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_TRENDS_DAILY, "http://api.twitter.com/1/trends/daily.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_TRENDS_WEEKLY, "http://api.twitter.com/1/trends/weekly.json");
    }
}

