/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler.json;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.Tweet;
import java.util.Hashtable;
import java.util.Vector;

public final class UserJSONHandler
extends DefaultJSONHandler {
    private Vector userList = new Vector(10);
    private Vector userHashList = new Vector(10);
    private long nextCursorIndex;
    private long prevCursorIndex;

    public UserJSONHandler() {
        super("root");
    }

    public void handle(JSONObject jsonObj) throws ParserException {
        if (this.isArray(jsonObj, this.startKey)) {
            this.handleAccounts(jsonObj.getJSONArray(this.startKey));
        } else if ((jsonObj = jsonObj.getJSONObject(this.startKey)).has("users")) {
            this.nextCursorIndex = Long.parseLong(jsonObj.getString("next_cursor"));
            this.prevCursorIndex = Long.parseLong(jsonObj.getString("previous_cursor"));
            this.handleAccounts(jsonObj.getJSONArray("users"));
        } else {
            this.handleAccount(jsonObj);
        }
    }

    public void handleAccounts(JSONArray jsonObj) throws ParserException {
        for (int i = 0; i < jsonObj.length(); ++i) {
            this.handleAccount(jsonObj.getJSONObject(i));
        }
    }

    public void handleAccount(JSONObject jsonObj) throws ParserException {
        Hashtable<String, Tweet> accountValues = new Hashtable<String, Tweet>(25);
        Hashtable lastTweetValues = new Hashtable(5);
        new UserAccountHandler().populate(accountValues, jsonObj);
        if (jsonObj.has("status")) {
            new TweetHandler().populate(lastTweetValues, jsonObj.getJSONObject("status"));
            if (lastTweetValues.size() > 0) {
                accountValues.put("USERACCOUNT_LAST_TWEET", new Tweet(lastTweetValues));
            }
        }
        this.userHashList.addElement(accountValues);
        this.userList.addElement(new UserAccount(accountValues));
    }

    public UserAccount[] getParsedUserAccounts() {
        Object[] users = new UserAccount[this.userList.size()];
        this.userList.copyInto(users);
        return users;
    }

    public void loadParsedUserAccount(UserAccount user, int index) {
        user.setData((Hashtable)this.userHashList.elementAt(index));
    }

    public long getNextCursorIndex() {
        return this.nextCursorIndex;
    }

    public long getPreviousCursorIndex() {
        return this.prevCursorIndex;
    }
}

