/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler.json;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.parser.ParserException;
import java.util.Vector;

public final class UserIdJSONHandler
extends DefaultJSONHandler {
    private Vector idsList = new Vector(10);
    private final long maxCount;
    private long nextCursorIndex;
    private long prevCursorIndex;

    public UserIdJSONHandler() {
        this(Long.MAX_VALUE);
    }

    public UserIdJSONHandler(long maxCount) {
        super("root");
        this.maxCount = maxCount;
    }

    public void handle(JSONObject jsonObj) throws ParserException {
        if ((jsonObj = jsonObj.getJSONObject(this.startKey)).has("ids")) {
            this.nextCursorIndex = Long.parseLong(jsonObj.getString("next_cursor"));
            this.prevCursorIndex = Long.parseLong(jsonObj.getString("previous_cursor"));
            this.handleAccounts(jsonObj.getJSONArray("ids"));
        }
    }

    public void handleAccounts(JSONArray jsonObj) throws ParserException {
        for (int i = 0; i < jsonObj.length() && (long)i < this.maxCount; ++i) {
            this.idsList.addElement(jsonObj.get(i).toString());
        }
    }

    public String[] getParsedIds() {
        Object[] ids = new String[this.idsList.size()];
        this.idsList.copyInto(ids);
        return ids;
    }

    public long getNextCursorIndex() {
        return this.nextCursorIndex;
    }

    public long getPreviousCursorIndex() {
        return this.prevCursorIndex;
    }

    public void clear() {
        this.idsList.removeAllElements();
        this.nextCursorIndex = 0L;
        this.prevCursorIndex = 0L;
    }
}

