/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler.json;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.GeoLocationHandler;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import com.twitterapime.search.TweetEntity;
import com.twitterapime.search.handler.TweetEntityHandler;
import java.util.Hashtable;
import java.util.Vector;

public final class StatusJSONHandler
extends DefaultJSONHandler {
    private Vector statusList = new Vector(10);
    private Vector statusHashList = new Vector(10);
    private SearchDeviceListener listener;

    public StatusJSONHandler() {
        super("root");
    }

    public void handle(JSONObject jsonObj) throws ParserException {
        if (this.isArray(jsonObj, this.startKey)) {
            this.handleStatuses(jsonObj.getJSONArray(this.startKey));
        } else if ((jsonObj = jsonObj.getJSONObject(this.startKey)).has("statuses")) {
            this.handleStatuses(jsonObj.getJSONArray("statuses"));
        } else {
            this.handleStatus(jsonObj);
        }
    }

    public void handleStatuses(JSONArray jsonObj) throws ParserException {
        for (int i = 0; i < jsonObj.length(); ++i) {
            this.handleStatus(jsonObj.getJSONObject(i));
        }
    }

    public void handleStatus(JSONObject jsonObj) throws ParserException {
        Hashtable<String, Tweet> statusValues = new Hashtable<String, Tweet>(10);
        TweetHandler tweetHandler = new TweetHandler();
        tweetHandler.populate(statusValues, jsonObj);
        this.populateUser(statusValues, jsonObj);
        this.populateEntity(statusValues, jsonObj);
        this.populateLocation(statusValues, jsonObj);
        this.populateSender(statusValues, jsonObj);
        this.populateRecipient(statusValues, jsonObj);
        if (jsonObj.has("retweeted_status")) {
            jsonObj = jsonObj.getJSONObject("retweeted_status");
            Hashtable retweetValues = new Hashtable(25);
            tweetHandler.populate(retweetValues, jsonObj);
            if (retweetValues.size() > 0) {
                this.populateUser(retweetValues, jsonObj);
                this.populateEntity(retweetValues, jsonObj);
                this.populateLocation(retweetValues, jsonObj);
                statusValues.put("TWEET_REPOSTED_TWEET", new Tweet(retweetValues));
            }
        }
        Tweet status = new Tweet(statusValues);
        this.fireStatusParsed(status);
        this.statusHashList.addElement(statusValues);
        this.statusList.addElement(status);
    }

    public Tweet[] getParsedTweets() {
        Object[] ts = new Tweet[this.statusList.size()];
        this.statusList.copyInto(ts);
        return ts;
    }

    public void loadParsedTweet(Tweet tweet, int index) {
        tweet.setData((Hashtable)this.statusHashList.elementAt(index));
    }

    public void setSearchDeviceListener(SearchDeviceListener listener) {
        this.listener = listener;
    }

    private void fireStatusParsed(Tweet tweet) {
        if (this.listener != null) {
            this.listener.tweetFound(tweet);
        }
    }

    private void populateUser(Hashtable tweetValues, JSONObject jsonObj) {
        if (jsonObj.has("user")) {
            Hashtable userValues = new Hashtable(25);
            new UserAccountHandler().populate(userValues, jsonObj.getJSONObject("user"));
            if (userValues.size() > 0) {
                tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(userValues));
            }
        }
    }

    private void populateEntity(Hashtable tweetValues, JSONObject jsonObj) {
        if (jsonObj.has("entities")) {
            Hashtable entityValues = new Hashtable(3);
            new TweetEntityHandler().populate(entityValues, jsonObj.getJSONObject("entities"));
            if (entityValues.size() > 0) {
                tweetValues.put("TWEET_ENTITY", new TweetEntity(entityValues));
            }
        }
    }

    private void populateLocation(Hashtable tweetValues, JSONObject jsonObj) {
        Hashtable geoValues = new Hashtable(5);
        GeoLocationHandler handler = new GeoLocationHandler();
        if (jsonObj.has("geo") && !jsonObj.get("geo").toString().equals("null")) {
            handler.populate(geoValues, jsonObj.getJSONObject("geo"));
        }
        if (jsonObj.has("place") && !jsonObj.get("place").toString().equals("null")) {
            handler.populate(geoValues, jsonObj.getJSONObject("place"));
        }
        if (geoValues.size() > 0) {
            tweetValues.put("TWEET_LOCATION", new GeoLocation(geoValues));
        }
    }

    private void populateSender(Hashtable tweetValues, JSONObject jsonObj) {
        if (jsonObj.has("sender")) {
            Hashtable senderValues = new Hashtable(3);
            new UserAccountHandler().populate(senderValues, jsonObj.getJSONObject("sender"));
            if (senderValues.size() > 0) {
                tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(senderValues));
            }
        }
    }

    private void populateRecipient(Hashtable tweetValues, JSONObject jsonObj) {
        if (jsonObj.has("recipient")) {
            Hashtable recipientValues = new Hashtable(3);
            new UserAccountHandler().populate(recipientValues, jsonObj.getJSONObject("recipient"));
            if (recipientValues.size() > 0) {
                tweetValues.put("TWEET_RECIPIENT_ACCOUNT", new UserAccount(recipientValues));
            }
        }
    }
}

