/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler.json;

import com.twitterapime.parser.DefaultJSONHandler;
import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.List;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class ListJSONHandler
extends DefaultJSONHandler {
    private Vector lists = new Vector(10);

    public ListJSONHandler() {
        super("root");
    }

    public void handle(JSONObject jsonObj) throws ParserException {
        if (this.isArray(jsonObj, this.startKey)) {
            this.handleLists(jsonObj.getJSONArray(this.startKey));
        } else {
            this.handleList(jsonObj.getJSONObject(this.startKey));
        }
    }

    public void handleLists(JSONArray jsonObj) throws ParserException {
        for (int i = 0; i < jsonObj.length(); ++i) {
            this.handleList(jsonObj.getJSONObject(i));
        }
    }

    public void handleList(JSONObject jsonObj) throws ParserException {
        Hashtable<String, Object> listValues = new Hashtable<String, Object>(25);
        this.putIf(listValues, "LIST_ID", jsonObj, "id");
        this.putIf(listValues, "LIST_NAME", jsonObj, "name");
        this.putIf(listValues, "LIST_FULL_NAME", jsonObj, "full_name");
        this.putIf(listValues, "LIST_SLUG", jsonObj, "slug");
        this.putIf(listValues, "LIST_DESCRIPTION", jsonObj, "description");
        this.putIf(listValues, "LIST_SUBSCRIBER_COUNT", jsonObj, "subscriber_count");
        this.putIf(listValues, "LIST_MEMBER_COUNT", jsonObj, "member_count");
        this.putIf(listValues, "LIST_URI", jsonObj, "uri");
        this.putIf(listValues, "LIST_FOLLOWING", jsonObj, "following");
        this.putIf(listValues, "LIST_MODE", jsonObj, "mode");
        if (jsonObj.has("created_at")) {
            listValues.put("LIST_CREATE_DATE", String.valueOf(StringUtil.convertTweetDateToLong(jsonObj.getString("created_at"))));
        }
        if (jsonObj.has("user")) {
            Hashtable userValues = new Hashtable(25);
            new UserAccountHandler().populate(userValues, jsonObj.getJSONObject("user"));
            if (userValues.size() > 0) {
                listValues.put("LIST_USER_ACCOUNT", new UserAccount(userValues));
            }
        }
        this.lists.addElement(new List(listValues));
    }

    public List[] getParsedLists() {
        Object[] ts = new List[this.lists.size()];
        this.lists.copyInto(ts);
        return ts;
    }

    private void putIf(Hashtable data, String dataKey, JSONObject jsonObj, String jsonKey) {
        if (jsonObj.has(jsonKey)) {
            data.put(dataKey, jsonObj.getString(jsonKey));
        }
    }
}

