/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.JSONObject;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;

public final class UserAccountHandler {
    public void populate(Hashtable data, String path, String text) {
        if (path.endsWith("/id")) {
            data.put("USERACCOUNT_ID", text);
        } else if (path.endsWith("/name")) {
            data.put("USERACCOUNT_NAME", text);
        } else if (path.endsWith("/screen_name")) {
            data.put("USERACCOUNT_USER_NAME", text);
            String picUri = "http://api.twitter.com/1/users/profile_image/" + text + ".json?size=";
            data.put("USERACCOUNT_PICTURE_URI_MINI", picUri + "mini");
            data.put("USERACCOUNT_PICTURE_URI_NORMAL", picUri + "normal");
            data.put("USERACCOUNT_PICTURE_URI_BIGGER", picUri + "bigger");
        } else if (path.endsWith("/location")) {
            data.put("USERACCOUNT_LOCATION", text);
        } else if (path.endsWith("/description")) {
            data.put("USERACCOUNT_DESCRIPTION", text);
        } else if (path.endsWith("/profile_image_url")) {
            data.put("USERACCOUNT_PICTURE_URI", text);
        } else if (path.endsWith("/url")) {
            data.put("USERACCOUNT_URL", text);
        } else if (path.endsWith("/protected")) {
            data.put("USERACCOUNT_PROTECTED", text);
        } else if (path.endsWith("/followers_count")) {
            data.put("USERACCOUNT_FOLLOWERS_COUNT", text);
        } else if (path.endsWith("/profile_background_color")) {
            data.put("USERACCOUNT_PROFILE_BACKGROUND_COLOR", text);
        } else if (path.endsWith("/profile_text_color")) {
            data.put("USERACCOUNT_PROFILE_TEXT_COLOR", text);
        } else if (path.endsWith("/profile_link_color")) {
            data.put("USERACCOUNT_PROFILE_LINK_COLOR", text);
        } else if (path.endsWith("/friends_count")) {
            data.put("USERACCOUNT_FRIENDS_COUNT", text);
        } else if (path.endsWith("/created_at")) {
            data.put("USERACCOUNT_CREATE_DATE", "" + StringUtil.convertTweetDateToLong(text));
        } else if (path.endsWith("/favourites_count")) {
            data.put("USERACCOUNT_FAVOURITES_COUNT", text);
        } else if (path.endsWith("/utc_offset")) {
            data.put("USERACCOUNT_UTC_OFFSET", text);
        } else if (path.endsWith("/time_zone")) {
            data.put("USERACCOUNT_TIME_ZONE", text);
        } else if (path.endsWith("/profile_background_image_url")) {
            data.put("USERACCOUNT_PROFILE_BACKGROUND_IMAGE_URI", text);
        } else if (path.endsWith("/statuses_count")) {
            data.put("USERACCOUNT_TWEETS_COUNT", text);
        } else if (path.endsWith("/notifications")) {
            data.put("USERACCOUNT_NOTIFICATIONS", text);
        } else if (path.endsWith("/verified")) {
            data.put("USERACCOUNT_VERIFIED", text);
        } else if (path.endsWith("/geo_enabled")) {
            data.put("USERACCOUNT_GEO_ENABLED", text);
        }
    }

    public void populate(Hashtable data, JSONObject jsonObj) {
        this.putIf(data, "USERACCOUNT_ID", jsonObj, "id");
        this.putIf(data, "USERACCOUNT_NAME", jsonObj, "name");
        this.putIf(data, "USERACCOUNT_USER_NAME", jsonObj, "screen_name");
        this.putIf(data, "USERACCOUNT_LOCATION", jsonObj, "location");
        this.putIf(data, "USERACCOUNT_DESCRIPTION", jsonObj, "description");
        this.putIf(data, "USERACCOUNT_PICTURE_URI", jsonObj, "profile_image_url");
        this.putIf(data, "USERACCOUNT_URL", jsonObj, "url");
        this.putIf(data, "USERACCOUNT_UTC_OFFSET", jsonObj, "utc_offset");
        this.putIf(data, "USERACCOUNT_TIME_ZONE", jsonObj, "time_zone");
        this.putIf(data, "USERACCOUNT_PROTECTED", jsonObj, "protected");
        this.putIf(data, "USERACCOUNT_NOTIFICATIONS", jsonObj, "notifications");
        this.putIf(data, "USERACCOUNT_VERIFIED", jsonObj, "verified");
        this.putIf(data, "USERACCOUNT_GEO_ENABLED", jsonObj, "geo_enabled");
        this.putIf(data, "USERACCOUNT_TWEETS_COUNT", jsonObj, "statuses_count");
        this.putIf(data, "USERACCOUNT_FAVOURITES_COUNT", jsonObj, "favourites_count");
        this.putIf(data, "USERACCOUNT_FOLLOWERS_COUNT", jsonObj, "followers_count");
        this.putIf(data, "USERACCOUNT_FRIENDS_COUNT", jsonObj, "friends_count");
        this.putIf(data, "USERACCOUNT_PROFILE_BACKGROUND_COLOR", jsonObj, "profile_background_color");
        this.putIf(data, "USERACCOUNT_PROFILE_TEXT_COLOR", jsonObj, "profile_text_color");
        this.putIf(data, "USERACCOUNT_PROFILE_LINK_COLOR", jsonObj, "profile_link_color");
        this.putIf(data, "USERACCOUNT_PROFILE_BACKGROUND_IMAGE_URI", jsonObj, "profile_background_image_url");
        if (jsonObj.has("created_at")) {
            data.put("USERACCOUNT_CREATE_DATE", String.valueOf(StringUtil.convertTweetDateToLong(jsonObj.getString("created_at"))));
        }
        if (jsonObj.has("screen_name")) {
            String picUri = "http://api.twitter.com/1/users/profile_image/" + jsonObj.getString("screen_name") + ".json?size=";
            data.put("USERACCOUNT_PICTURE_URI_MINI", picUri + "mini");
            data.put("USERACCOUNT_PICTURE_URI_NORMAL", picUri + "normal");
            data.put("USERACCOUNT_PICTURE_URI_BIGGER", picUri + "bigger");
        }
    }

    private void putIf(Hashtable data, String dataKey, JSONObject jsonObj, String jsonKey) {
        if (jsonObj.has(jsonKey)) {
            data.put(dataKey, jsonObj.getString(jsonKey));
        }
    }
}

