/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.JSONObject;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;

public final class TweetHandler {
    public void populate(Hashtable data, String path, String text) {
        if (path.endsWith("/created_at")) {
            data.put("TWEET_PUBLISH_DATE", "" + StringUtil.convertTweetDateToLong(text));
        } else if (path.endsWith("/id")) {
            data.put("TWEET_ID", text);
        } else if (path.endsWith("/text")) {
            data.put("TWEET_CONTENT", text);
        } else if (path.endsWith("/source")) {
            data.put("TWEET_SOURCE", StringUtil.removeTags(text));
        } else if (path.endsWith("/favorited")) {
            data.put("TWEET_FAVOURITE", text);
        } else if (path.endsWith("/in_reply_to_status_id")) {
            data.put("TWEET_IN_REPLY_TO_TWEET_ID", text);
        }
    }

    public void populate(Hashtable data, JSONObject jsonObj) {
        this.putIf(data, "TWEET_ID", jsonObj, "id");
        this.putIf(data, "TWEET_CONTENT", jsonObj, "text");
        this.putIf(data, "TWEET_FAVOURITE", jsonObj, "favorited");
        this.putIf(data, "TWEET_IN_REPLY_TO_TWEET_ID", jsonObj, "in_reply_to_status_id");
        if (jsonObj.has("created_at")) {
            data.put("TWEET_PUBLISH_DATE", String.valueOf(StringUtil.convertTweetDateToLong(jsonObj.getString("created_at"))));
        }
        if (jsonObj.has("source")) {
            data.put("TWEET_SOURCE", StringUtil.removeTags(jsonObj.getString("source")));
        }
    }

    private void putIf(Hashtable data, String dataKey, JSONObject jsonObj, String jsonKey) {
        if (jsonObj.has(jsonKey)) {
            data.put(dataKey, jsonObj.getString(jsonKey));
        }
    }
}

